/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.transformation.registry;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.app4mc.transformation.transformers.Model2ModelRootTransformer;
import org.eclipse.app4mc.transformation.transformers.Model2TextRootTransformer;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

@Component(configurationPid={"TRANSFORMATION_SESSION_CONFIG"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={TransformerRegistry.class})
public class TransformerRegistry {
    private String logFilePath;
    private AtomicBoolean transformationStarted = new AtomicBoolean(false);
    LoggerFactory factory;
    Logger osgiLogger;
    @Reference
    EventAdmin eventAdmin;
    SessionLogger logger;
    String sessionName;
    private List<Model2ModelRootTransformer> m2mTransformers = new ArrayList<Model2ModelRootTransformer>();
    private List<Model2TextRootTransformer> m2tTransformers = new ArrayList<Model2TextRootTransformer>();

    @Activate
    void activate(Map<String, ?> properties) {
        this.logFilePath = (String)properties.get("log_file");
        this.sessionName = (String)properties.get("SESSION_ID");
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    void setLogger(LoggerFactory factory) {
        this.factory = factory;
        this.osgiLogger = factory.getLogger(this.getClass());
    }

    void unsetLogger(LoggerFactory loggerFactory) {
        if (this.factory == loggerFactory) {
            this.factory = null;
            this.osgiLogger = null;
        }
    }

    @Reference(name="sessionLogger")
    public void setSessionLogger(SessionLogger logger) {
        this.logger = logger;
    }

    @Reference(name="m2mTransformers", cardinality=ReferenceCardinality.MULTIPLE)
    public void registerM2mTransformer(Model2ModelRootTransformer transformer) {
        this.m2mTransformers.add(transformer);
    }

    @Reference(name="m2tTransformers", cardinality=ReferenceCardinality.MULTIPLE)
    public void registerM2tTransformer(Model2TextRootTransformer transformer) {
        this.m2tTransformers.add(transformer);
    }

    public void startTransformation() {
        if (this.transformationStarted.compareAndSet(false, true)) {
            this.start();
        }
    }

    void start() {
        try {
            this.logger.info("Starting Model transformation ...", new Object[0]);
            for (Model2ModelRootTransformer model2ModelRootTransformer : this.m2mTransformers) {
                this.logger.info("****************** Model to Model Transformation : {0} *******************************", new Object[]{model2ModelRootTransformer.getTransformationKey()});
                this.logger.info("** Executing M2M transformer : {0}", new Object[]{model2ModelRootTransformer.getClass().getTypeName()});
                model2ModelRootTransformer.setSessionLogger(this.logger);
                model2ModelRootTransformer.m2mTransformation();
            }
            for (Model2TextRootTransformer model2TextRootTransformer : this.m2tTransformers) {
                this.logger.info("****************** Model to Text Transformation : {0} ****************************", new Object[]{model2TextRootTransformer.getTransformationKey()});
                this.logger.info("** Executing M2T transformer : {0}", new Object[]{model2TextRootTransformer.getClass().getTypeName()});
                model2TextRootTransformer.setSessionLogger(this.logger);
                model2TextRootTransformer.m2tTransformation();
            }
        }
        catch (Throwable throwable) {
            this.logger.info("Transformation execution session \"{0}\" completed.", new Object[]{this.sessionName});
            this.stopSession();
            throw throwable;
        }
        this.logger.info("Transformation execution session \"{0}\" completed.", new Object[]{this.sessionName});
        this.stopSession();
    }

    private void stopSession() {
        this.logger.flush(new File(this.logFilePath));
        if (this.eventAdmin != null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("SESSION_ID", this.sessionName);
            this.eventAdmin.sendEvent(new Event("org/eclipse/app4mc/transformation/DONE", properties));
        }
    }

    public void startTransformation(Map<String, ?> properties) {
        this.logFilePath = (String)properties.get("log_file");
        this.sessionName = "single";
        if (this.logger == null) {
            this.logger = new SessionLogger();
        }
        this.start();
    }

    public void startTransformation(String logFilePath) {
        this.logFilePath = logFilePath;
        this.sessionName = "single";
        if (this.logger == null) {
            this.logger = new SessionLogger();
        }
        this.start();
    }
}

