/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.util.sessionlog;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.app4mc.util.sessionlog.SessionLogEntry;
import org.eclipse.app4mc.util.sessionlog.SessionLogWriter;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(factory="org.eclipse.app4mc.amalthea.sessionlog.factory", service={SessionLogger.class})
public class SessionLogger {
    CopyOnWriteArrayList<SessionLogWriter> logWriter = new CopyOnWriteArrayList();
    ArrayList<SessionLogEntry> log = new ArrayList();

    public void error(String msg, Object ... args) {
        String message = args != null && args.length > 0 ? MessageFormat.format(msg, args) : msg;
        Exception e = null;
        if (args != null && args.length > 0 && args[args.length - 1] instanceof Exception) {
            e = (Exception)args[args.length - 1];
        }
        this.log.add(new SessionLogEntry(SessionLogEntry.Status.ERROR, "ERROR: " + message, e));
    }

    public void warn(String msg, Object ... args) {
        String message = args != null && args.length > 0 ? MessageFormat.format(msg, args) : msg;
        this.log.add(new SessionLogEntry(SessionLogEntry.Status.WARNING, "WARN : " + message));
    }

    public void info(String msg, Object ... args) {
        String message = args != null && args.length > 0 ? MessageFormat.format(msg, args) : msg;
        this.log.add(new SessionLogEntry(SessionLogEntry.Status.INFO, "INFO : " + message));
    }

    public void flush(File sessionLogFile) {
        this.logWriter.forEach(w -> w.write(sessionLogFile, new ArrayList<SessionLogEntry>(this.log)));
        this.log.clear();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void registerLogWriter(SessionLogWriter writer) {
        this.logWriter.add(writer);
    }

    public void unregisterLogWriter(SessionLogWriter writer) {
        this.logWriter.remove(writer);
    }
}

