/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.linux.artefacts;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.eclipse.app4mc.slg.linux.artefacts.LinuxGoogleGuiceModuleFactory;
import org.eclipse.app4mc.slg.linux.transformers.LinuxModel2TextTransformer;
import org.eclipse.app4mc.transformation.transformers.Model2TextRootTransformer;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"TRANSFORMATION_SESSION_CONFIG"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"transformation=LINUX_SLG"}, service={Model2TextRootTransformer.class})
public class LinuxRootTransformer
extends Model2TextRootTransformer {
    @Reference
    private LinuxGoogleGuiceModuleFactory moduleFactory;
    Properties properties;

    @Activate
    protected void activate(Map<String, ?> properties) {
        super.activate(properties);
        this.properties = new Properties();
        this.properties.putAll(properties);
        this.properties.put("transformation_output_folder", this.getOutputFolder());
    }

    public void m2tTransformation() {
        Injector injector = Guice.createInjector((Module[])new Module[]{this.moduleFactory.getModule(this.logger, this.properties)});
        LinuxModel2TextTransformer instance = (LinuxModel2TextTransformer)((Object)injector.getInstance(LinuxModel2TextTransformer.class));
        this.harmonizeSLGParams(this.properties);
        instance.m2tTransformation(this.getInputResourceSet(this.getInputFolder(), this.logger));
    }

    private void harmonizeSLGParams(Properties props) {
        if (!props.containsKey("configurationFile")) {
            this.logger.error("'configurationFile' property not set in the input properties file", new Object[0]);
            throw new IllegalArgumentException("'configurationFile' property not set in the input properties file");
        }
        this.harmonizeSLGParam(props, "workingDirectory", "configurationFile");
    }

    private void harmonizeSLGParam(Properties props, String workingDirectoryKey, String param) {
        String workingDirectory = (String)props.get(workingDirectoryKey);
        String paramValue = (String)props.get(param);
        if (paramValue != null && workingDirectory != null) {
            File file = null;
            file = new File(paramValue);
            if (!file.exists() && (file = new File(workingDirectory, paramValue)).exists()) {
                props.put(param, file.getAbsolutePath());
            }
        }
    }
}

