/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.commons.m2t.transformers.sw;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.slg.commons.m2t.generators.LabelGenerator;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGBaseTransformer;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.transformation.util.OutputBuffer;

@Singleton
public class LabelTransformer
extends SLGBaseTransformer {
    public static final String LIB_NAME = "LABELS_LIB";
    public static final String BASE_PATH = "synthetic_gen";
    public static final String MODULE_NAME = "labels";
    public static final String MODULE_PATH = "synthetic_gen/labels";
    public static final String MAKEFILE_PATH = "synthetic_gen/labels/CMakeLists.txt";
    @Inject
    private OutputBuffer outputBuffer;
    private final Map<List<Object>, SLGTranslationUnit> transformCache = new HashMap<List<Object>, SLGTranslationUnit>();

    @Override
    public Map<List<Object>, SLGTranslationUnit> getCache() {
        return this.transformCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SLGTranslationUnit transform(Label label) {
        SLGTranslationUnit tu;
        ArrayList<Label> key = new ArrayList<Label>(Arrays.asList(label));
        Map<List<Object>, SLGTranslationUnit> map = this.transformCache;
        synchronized (map) {
            if (this.transformCache.containsKey(key)) {
                return this.transformCache.get(key);
            }
            tu = this.createTranslationUnit(label);
            this.transformCache.put(key, tu);
        }
        if (tu.isValid()) {
            this.doTransform(tu, label);
        }
        return tu;
    }

    protected SLGTranslationUnit createTranslationUnit(Label label) {
        if (label == null) {
            return new SLGTranslationUnit("UNSPECIFIED LABEL");
        }
        String basePath = BASE_PATH;
        String moduleName = MODULE_NAME;
        String call = label.getName();
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    protected void doTransform(SLGTranslationUnit tu, Label label) {
        this.genFiles(tu, label);
    }

    protected void genFiles(SLGTranslationUnit tu, Label label) {
        if (this.isSrcFileEmpty(tu)) {
            this.srcAppend(tu, "#include \"" + this.getIncFile(tu) + "\"\n\n");
        }
        if (this.isIncFileEmpty(tu)) {
            this.incAppend(tu, "#include <stdbool.h>\n\n");
        }
        this.incAppend(tu, LabelGenerator.toH(label));
        this.srcAppend(tu, LabelGenerator.toCpp(label));
    }

    public boolean createCMake() {
        return this.outputBuffer.appendTo("OTHER", MAKEFILE_PATH, LabelGenerator.toCMake(LIB_NAME, this.getSrcFiles()));
    }
}

