/**
 ********************************************************************************
 * Copyright (c) 2020-2021 Robert Bosch GmbH.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 * *******************************************************************************
 */

package org.eclipse.app4mc.slg.linux.generators

import org.eclipse.app4mc.slg.config.ConfigModel

class LinuxMakeGenerator {

	// Suppress default constructor
	private new() {
		throw new IllegalStateException("Utility class");
	}

private static def String getHeaderFilesDirectory(ConfigModel configModel){
	
	val StringBuffer buffer=new StringBuffer
	
	for(headerFile : configModel?.codeHooks?.headerFiles){
		for(hfileDir: headerFile.headerFilesDirectories){
			buffer.append("-I"+hfileDir+ " ")
		}
	}
	return buffer.toString.trim;
}
	static def String getContent(boolean experimentalCodeMatching, boolean instrumentation, boolean instrumentation_R, boolean externalCode, ConfigModel configModel) '''
		synthetic: main.o tasks.o runnables.o «IF experimentalCodeMatching»codesnippets.o«ENDIF» «IF instrumentation»instrument.o «ELSEIF instrumentation_R»instrument.o«ENDIF» «IF !experimentalCodeMatching» labels.o ticksUtils.o«ENDIF»
			gcc -o synthetic main.o tasks.o runnables.o «IF !experimentalCodeMatching» labels.o ticksUtils.o«ENDIF» «IF experimentalCodeMatching»codesnippets.o«ENDIF» «IF instrumentation_R»instrument.o «ELSEIF instrumentation»instrument.o«ENDIF» -pthread «IF externalCode»«FOR LibPath : configModel.codeHooks?.libLocations?.getLinkedLibraries()» «LibPath» «ENDFOR»«ENDIF»
		
		main.o: Executable/main/_src/main.c
			gcc -c «IF !experimentalCodeMatching»-Isynthetic_gen/labels/_inc -Isynthetic_gen/ticksUtils/_inc«ENDIF»  -Isynthetic_gen/tasks/_inc -Isynthetic_gen/runnables/_inc -Isynthetic_gen «IF externalCode»«getHeaderFilesDirectory(configModel)»«ENDIF» «IF experimentalCodeMatching»-Isynthetic_gen/codesnippets/_inc «ENDIF»Executable/main/_src/main.c
		
		tasks.o: synthetic_gen/tasks/_src/tasks.c
			gcc -c «IF !experimentalCodeMatching»-Isynthetic_gen/labels/_inc -Isynthetic_gen/ticksUtils/_inc«ENDIF»  -Isynthetic_gen/tasks/_inc -Isynthetic_gen/runnables/_inc «IF externalCode»«getHeaderFilesDirectory(configModel)»«ENDIF» «IF experimentalCodeMatching»-Isynthetic_gen/codesnippets/_inc «ENDIF»synthetic_gen/tasks/_src/tasks.c
			
		runnables.o: synthetic_gen/runnables/_src/runnables.c
			gcc -c «IF !experimentalCodeMatching»-Isynthetic_gen/labels/_inc -Isynthetic_gen/ticksUtils/_inc«ENDIF»  -Isynthetic_gen/runnables/_inc «IF externalCode»«getHeaderFilesDirectory(configModel)»«ENDIF» «IF experimentalCodeMatching»-Isynthetic_gen/codesnippets/_inc «ENDIF»synthetic_gen/runnables/_src/runnables.c -O2
		
		
		«IF !experimentalCodeMatching»
			labels.o: synthetic_gen/labels/_src/labels.c
				gcc -c -Isynthetic_gen/labels/_inc  synthetic_gen/labels/_src/labels.c -O2
			
			ticksUtils.o: synthetic_gen/ticksUtils/_src/ticksUtils.c
				gcc -c -Isynthetic_gen/ticksUtils/_inc synthetic_gen/ticksUtils/_src/ticksUtils.c -O2
			
		«ELSE»
			codesnippets.o: synthetic_gen/codesnippets/_src/codesnippets.c
				gcc -c -Isynthetic_gen/codesnippets/_inc synthetic_gen/codesnippets/_src/codesnippets.c
		«ENDIF»
		
		«IF instrumentation »	
			instrument.o: synthetic_gen/instrument.c
				gcc -c -Isynthetic_gen synthetic_gen/instrument.c
		«ELSEIF instrumentation_R »	
		instrument.o: synthetic_gen/tasks/_src/instrument.c
				gcc -c -Isynthetic_gen synthetic_gen/tasks/_src/instrument.c
		«ENDIF»
		
	'''

}
