/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.linux.transformers.sw;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.linux.generators.LinuxLabelGenerator;
import org.eclipse.app4mc.slg.linux.transformers.LinuxBaseTransformer;

@Singleton
public class LinuxLabelTransformer
extends LinuxBaseTransformer {
    private final Map<List<Object>, SLGTranslationUnit> transformCache = new HashMap<List<Object>, SLGTranslationUnit>();

    @Override
    public Map<List<Object>, SLGTranslationUnit> getCache() {
        return this.transformCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SLGTranslationUnit transform(Label label) {
        SLGTranslationUnit tu;
        ArrayList<Label> key = new ArrayList<Label>(Arrays.asList(label));
        Map<List<Object>, SLGTranslationUnit> map = this.transformCache;
        synchronized (map) {
            if (this.transformCache.containsKey(key)) {
                return this.transformCache.get(key);
            }
            tu = this.createTranslationUnit(label);
            this.transformCache.put(key, tu);
        }
        if (tu.isValid()) {
            this.doTransform(tu, label);
        }
        return tu;
    }

    private SLGTranslationUnit createTranslationUnit(Label label) {
        if (label == null) {
            return new SLGTranslationUnit("UNSPECIFIED LABEL");
        }
        String basePath = "synthetic_gen";
        String moduleName = "labels";
        String call = "burnTicks(<params>)";
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    private void doTransform(SLGTranslationUnit tu, Label label) {
        this.genFiles(tu, label);
    }

    private void genFiles(SLGTranslationUnit tu, Label label) {
        if (this.isSrcFileEmpty(tu)) {
            this.srcAppend(tu, "#include \"" + this.getIncFile(tu) + "\"\n");
            this.srcAppend(tu, "#include <stdbool.h>\n\n");
        }
        this.incAppend(tu, LinuxLabelGenerator.toH(label));
        this.srcAppend(tu, LinuxLabelGenerator.toCpp(label));
    }
}

