/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.commons.m2t.transformers.sw;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic;
import org.eclipse.app4mc.amalthea.model.NumericStatistic;
import org.eclipse.app4mc.amalthea.model.SingleValueStatistic;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.commons.m2t.transformers.sw.LabelTransformer;

@Singleton
public class LabelAccessTransformer {
    @Inject
    private LabelTransformer labelTransformer;

    public SLGTranslationUnit transform(LabelAccess labelAccess) {
        SLGTranslationUnit labelTU = this.labelTransformer.transform(labelAccess.getData());
        return this.createTranslationUnit(labelAccess, labelTU);
    }

    private SLGTranslationUnit createTranslationUnit(LabelAccess labelAccess, SLGTranslationUnit labelTU) {
        if (labelTU == null) {
            return new SLGTranslationUnit("UNSPECIFIED LABEL ACCESS");
        }
        String basePath = labelTU.getBasePath();
        String moduleName = labelTU.getModuleName();
        String call = this.computeCall(labelAccess);
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    private String computeCall(LabelAccess labelAccess) {
        if (labelAccess == null || labelAccess.getData() == null || labelAccess.getData().getName() == null || labelAccess.getData().getName().isEmpty()) {
            return "/* unspecified label access */";
        }
        if (labelAccess.getAccess() == LabelAccessEnum._UNDEFINED_) {
            return "/*underspecified access to label" + labelAccess.getData().getName() + "*/";
        }
        NumericStatistic stat = this.statisticValueOrNull(labelAccess);
        String statString = stat == null ? "1" : this.getNumericStatistic(stat);
        switch (labelAccess.getAccess()) {
            case READ: {
                return "read_" + labelAccess.getData().getName() + "(" + statString + ")";
            }
            case WRITE: {
                return "write_" + labelAccess.getData().getName() + "(" + statString + ")";
            }
        }
        return null;
    }

    private NumericStatistic statisticValueOrNull(LabelAccess access) {
        if (access == null || access.getStatistic() == null) {
            return null;
        }
        return access.getStatistic().getValue();
    }

    private String getNumericStatistic(NumericStatistic statistic) {
        if (statistic instanceof MinAvgMaxStatistic) {
            MinAvgMaxStatistic minAvgMaxStatistic = (MinAvgMaxStatistic)statistic;
            Float avg = Float.valueOf(minAvgMaxStatistic.getAvg());
            Double ceil = Math.ceil(avg.floatValue());
            String valueString = String.format("%d", ceil.intValue());
            return String.valueOf(valueString) + " /*MinAvgMaxStatistic not supported yet*/";
        }
        if (statistic instanceof SingleValueStatistic) {
            Float value = Float.valueOf(((SingleValueStatistic)statistic).getValue());
            Double ceil = Math.ceil(value.doubleValue());
            return String.format("%d", ceil.intValue());
        }
        return null;
    }
}

