/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.transformation.util;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.transformation.util.FileHelper;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;

@Singleton
public class OutputBuffer {
    SessionLogger logger;
    private final HashMap<String, TypedBuffer> filetypeToBufferMap = new HashMap();
    private String outputFolder;
    private List<Path> excludePathsOfResult = Collections.emptyList();

    @Inject
    public void setSessionLogger(SessionLogger logger) {
        this.logger = logger;
    }

    public void initialize(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void configureFiletype(String type, String fileExtension, String header, String footer) {
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("Illegal type string");
        }
        if (this.filetypeToBufferMap.containsKey(type)) {
            throw new IllegalArgumentException("Type is already configured");
        }
        this.filetypeToBufferMap.put(type, new TypedBuffer(fileExtension, header, footer));
    }

    public boolean appendTo(String type, String targetFile, String content) {
        if (!this.filetypeToBufferMap.containsKey(type)) {
            throw new IllegalArgumentException("Unknown type");
        }
        if (targetFile == null || targetFile.isEmpty()) {
            throw new IllegalArgumentException("Undefined filename");
        }
        return this.filetypeToBufferMap.get(type).appendTo(targetFile, content);
    }

    public void finish() {
        this.finish(true, false);
    }

    public void finish(boolean createZip, boolean writeChangedFilesOnly) {
        for (TypedBuffer typedBuffer : this.filetypeToBufferMap.values()) {
            for (Map.Entry entry : typedBuffer.filenameToBufferMap.entrySet()) {
                String targetFile = (String)entry.getKey();
                StringBuilder buffer = (StringBuilder)entry.getValue();
                StringBuilder builder = new StringBuilder(typedBuffer.header.length() + buffer.length() + typedBuffer.footer.length());
                builder.append(typedBuffer.header);
                builder.append((CharSequence)buffer);
                builder.append(typedBuffer.footer);
                String newContent = builder.toString();
                File file = this.getFile(this.outputFolder, String.valueOf(targetFile) + typedBuffer.fileExtension);
                if (writeChangedFilesOnly && this.contentEquals(file, newContent)) continue;
                try {
                    Throwable throwable = null;
                    Object var13_16 = null;
                    try {
                        FileWriter fw = new FileWriter(file);
                        try {
                            try (BufferedWriter writer = new BufferedWriter(fw);){
                                writer.append(newContent);
                                writer.flush();
                            }
                            if (fw == null) continue;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (fw != null) {
                                fw.close();
                            }
                            throw throwable;
                        }
                        fw.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.logger.error("Failed to write result file: {0}", new Object[]{targetFile});
                }
            }
        }
        if (createZip) {
            try {
                FileHelper.zipResult(this.outputFolder, this.excludePathsOfResult, this.logger);
            }
            catch (Exception e) {
                this.logger.error("Failed to produce result zip archive: ", new Object[]{e});
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean contentEquals(File file, String newContent) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File getFile(String outputFolder, String targetFile) {
        File file = new File(outputFolder, targetFile);
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        return file;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public String getFileExtension(String type) {
        TypedBuffer typedBuffer = this.filetypeToBufferMap.get(type);
        if (typedBuffer == null) {
            return null;
        }
        return typedBuffer.getFileExtension();
    }

    public boolean bufferExists(String type, String targetFile) {
        TypedBuffer typedBuffer = this.filetypeToBufferMap.get(type);
        return typedBuffer != null && typedBuffer.filenameToBufferMap.containsKey(targetFile);
    }

    public void setExcludePathsOfResult(List<Path> excludePathsOfResult) {
        this.excludePathsOfResult = excludePathsOfResult;
    }

    private class TypedBuffer {
        private final HashMap<String, StringBuilder> filenameToBufferMap = new HashMap();
        private String fileExtension = "";
        private String header = "";
        private String footer = "";

        public TypedBuffer(String fileExtension, String header, String footer) {
            if (fileExtension != null) {
                this.fileExtension = fileExtension;
            }
            if (header != null) {
                this.header = header;
            }
            if (footer != null) {
                this.footer = footer;
            }
        }

        public boolean appendTo(String targetFile, String content) {
            boolean isNewBuffer = false;
            if (!this.filenameToBufferMap.containsKey(targetFile)) {
                this.filenameToBufferMap.put(targetFile, new StringBuilder());
                isNewBuffer = true;
            }
            this.filenameToBufferMap.get(targetFile).append(content);
            return isNewBuffer;
        }

        public String getFileExtension() {
            return this.fileExtension;
        }
    }
}

