/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.customization;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.InterProcessTrigger;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Ticks;
import org.eclipse.app4mc.slg.commons.m2t.CustomObjectsStore;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.commons.m2t.transformers.sw.ActivityGraphItemTransformer;
import org.eclipse.app4mc.slg.commons.m2t.transformers.sw.RunnableTransformer;
import org.eclipse.app4mc.slg.customization.CustomRunnableGenerator;
import org.eclipse.emf.ecore.EObject;

@Singleton
public class CustomRunnableTransformer
extends RunnableTransformer {
    @Inject
    private ActivityGraphItemTransformer activityGraphItemTransformer;
    @Inject
    private CustomObjectsStore customObjsStore;
    @Inject
    private Properties properties;
    private final Map<List<Object>, SLGTranslationUnit> transformCache = new HashMap<List<Object>, SLGTranslationUnit>();

    public Map<List<Object>, SLGTranslationUnit> getCache() {
        return this.transformCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SLGTranslationUnit transform(Runnable runnable) {
        SLGTranslationUnit tu;
        ArrayList<Runnable> key = new ArrayList<Runnable>(Arrays.asList(runnable));
        Map<List<Object>, SLGTranslationUnit> map = this.transformCache;
        synchronized (map) {
            if (this.transformCache.containsKey(key)) {
                return this.transformCache.get(key);
            }
            tu = this.createTranslationUnit(runnable);
            this.transformCache.put(key, tu);
        }
        if (tu.isValid()) {
            this.doTransform(tu, runnable);
        }
        return tu;
    }

    protected SLGTranslationUnit createTranslationUnit(Runnable runnable) {
        if (runnable == null) {
            return new SLGTranslationUnit("UNSPECIFIED RUNNABLE");
        }
        String basePath = "synthetic_gen";
        String moduleName = "runnables";
        String call = "run_" + runnable.getName();
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    protected void doTransform(SLGTranslationUnit tu, Runnable runnable) {
        this.genFiles(tu, runnable);
    }

    protected void genFiles(SLGTranslationUnit tu, Runnable runnable) {
        boolean extOverwrite = false;
        if (this.isSrcFileEmpty(tu)) {
            this.srcAppend(tu, "#include \"" + this.getIncFile(tu) + "\"\n");
            this.srcAppend(tu, "#include \"ticksUtils.h\"\n");
        }
        LinkedHashSet<String> includes = new LinkedHashSet<String>();
        ArrayList<String> calls = new ArrayList<String>();
        ArrayList callsOverwrite = new ArrayList();
        ArrayList<Process> processedTasks = new ArrayList<Process>();
        if (runnable != null && runnable.getActivityGraph() != null) {
            extOverwrite = this.processCustomProperties(extOverwrite, calls, callsOverwrite, runnable.getActivityGraph());
            for (EObject item : runnable.getActivityGraph().eContents()) {
                String call;
                if (item instanceof Ticks) {
                    Ticks ticks = (Ticks)item;
                    Map translationUnits = this.activityGraphItemTransformer.transformAllItems(ticks);
                    SLGTranslationUnit defaultTicksTU = null;
                    boolean ticksAssociatedToPUs = false;
                    for (Map.Entry entry : translationUnits.entrySet()) {
                        String call2;
                        String puName = (String)entry.getKey();
                        SLGTranslationUnit tmpTU = (SLGTranslationUnit)entry.getValue();
                        if (puName.equals("default")) {
                            defaultTicksTU = tmpTU;
                            continue;
                        }
                        String tmpIncFile = this.getIncFile(tmpTU);
                        if (tmpIncFile != null && !tmpIncFile.isEmpty() && !this.getIncFile(tu).equals(tmpIncFile)) {
                            includes.add(tmpIncFile);
                        }
                        if ((call2 = tmpTU.getCall()) == null || call2.isEmpty()) continue;
                        calls.add(ticksAssociatedToPUs ? "else if(strcmp(coreName,\"" + puName + "\")==0){" : " if(strcmp(coreName,\"" + puName + "\")==0){");
                        calls.add(call2);
                        calls.add("}");
                        ticksAssociatedToPUs = true;
                    }
                    if (defaultTicksTU == null) continue;
                    if (ticksAssociatedToPUs) {
                        calls.add("else ");
                        calls.add("{");
                    }
                    if (defaultTicksTU.getCall() != null && !defaultTicksTU.getCall().isEmpty()) {
                        calls.add(defaultTicksTU.getCall());
                    }
                    if (!ticksAssociatedToPUs) continue;
                    calls.add("}");
                    continue;
                }
                if (!(item instanceof ActivityGraphItem)) continue;
                if (item instanceof InterProcessTrigger) {
                    InterProcessTrigger trigger = (InterProcessTrigger)item;
                    String value = CustomRunnableGenerator.handleInterProcessTrigger((Stimulus)trigger.getStimulus(), processedTasks);
                    if (value == null || value.trim().isEmpty()) continue;
                    calls.add(value);
                    continue;
                }
                SLGTranslationUnit tmpTU = this.activityGraphItemTransformer.transform((ActivityGraphItem)item);
                String tmpIncFile = this.getIncFile(tmpTU);
                if (tmpIncFile != null && !tmpIncFile.isEmpty() && !this.getIncFile(tu).equals(tmpIncFile)) {
                    includes.add(tmpIncFile);
                }
                if ((call = tmpTU.getCall()) == null || call.isEmpty()) continue;
                calls.add(call);
            }
        }
        String runnableName = runnable.getName();
        this.toH(tu, runnableName, includes);
        this.srcAppend(tu, "\n//Runnable " + runnableName + "----\n");
        if (extOverwrite) {
            String call_overwrite = "run_" + runnable.getName();
            this.srcAppend(tu, "void " + call_overwrite + "(char* coreName){\n" + "\n");
            for (String call : callsOverwrite) {
                this.srcAppend(tu, String.valueOf(call) + ";" + "\n");
            }
            this.srcAppend(tu, "\n}\n");
        } else {
            this.toCpp(tu, calls);
        }
    }

    protected void toCpp(SLGTranslationUnit tu, List<String> calls) {
        this.srcAppend(tu, "void " + tu.getCall() + "(char* coreName){\n");
        for (String call : calls) {
            this.srcAppend(tu, "\t" + call + (call.endsWith(")") ? ";" : "") + "\n");
        }
        this.srcAppend(tu, "}\n\n");
    }
}

