/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.linux.transformers;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.StimuliModel;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.app4mc.slg.commons.m2t.transformers.AmaltheaModel2TextTransformer;
import org.eclipse.app4mc.slg.commons.m2t.transformers.sw.InstrumentationTransformer;
import org.eclipse.app4mc.slg.commons.m2t.transformers.sw.RunnableTransformer;
import org.eclipse.app4mc.slg.linux.transformers.LinuxBaseSettings;
import org.eclipse.app4mc.slg.linux.transformers.stimuli.LinuxStimulusTransformer;
import org.eclipse.app4mc.slg.linux.transformers.sw.LinuxMakeTransformer;
import org.eclipse.app4mc.slg.linux.transformers.sw.LinuxRealisticCodeTransformer;
import org.eclipse.app4mc.slg.linux.transformers.sw.LinuxRunnableTransformer;
import org.eclipse.app4mc.slg.linux.transformers.sw.LinuxTaskTransformer;
import org.eclipse.app4mc.transformation.util.OutputBuffer;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;

public class LinuxModel2TextTransformer
extends AmaltheaModel2TextTransformer {
    @Inject
    private SessionLogger logger;
    @Inject
    private OutputBuffer outputBuffer;
    @Inject
    private LinuxMakeTransformer linuxMakeTransformer;
    @Inject
    private LinuxRealisticCodeTransformer realisticCodeBasedOnCodeSnippet;
    @Inject
    private LinuxStimulusTransformer stimuliTransformer;
    @Inject
    private LinuxRunnableTransformer linuxRunnableTransformer;
    @Inject
    private RunnableTransformer defaultRunnableTransformer;
    @Inject
    private LinuxTaskTransformer taskTransformer;
    @Inject
    private InstrumentationTransformer instrumentationTransformer;

    public void transform(Amalthea model, String outputFolder) {
        boolean experimentalCodeSnippetMatching = Boolean.parseBoolean(this.getProperty("experimentalCodeSnippetMatching"));
        boolean enableInstrumentation = Boolean.parseBoolean(this.getProperty("enableInstrumentation_Tasks"));
        boolean enableInstrumentation_R = Boolean.parseBoolean(this.getProperty("enableInstrumentation_Runnables"));
        StimuliModel stimuliModel = ModelUtil.getOrCreateStimuliModel((Amalthea)model);
        SWModel swModel = ModelUtil.getOrCreateSwModel((Amalthea)model);
        this.logger.info("Starting Linux SLG code generation", new Object[0]);
        LinuxBaseSettings.initializeOutputBuffer(this.outputBuffer, outputFolder);
        if (experimentalCodeSnippetMatching) {
            this.realisticCodeBasedOnCodeSnippet.transform();
        }
        this.stimuliTransformer.transform((List<Stimulus>)stimuliModel.getStimuli());
        for (Runnable runnable : swModel.getRunnables()) {
            if (experimentalCodeSnippetMatching) {
                this.linuxRunnableTransformer.transform(runnable);
                continue;
            }
            this.defaultRunnableTransformer.transform(runnable);
        }
        for (Task task : swModel.getTasks()) {
            this.taskTransformer.transform(task);
        }
        if (enableInstrumentation) {
            this.instrumentationTransformer.transform("synthetic_gen/instrument");
        }
        if (enableInstrumentation_R) {
            this.instrumentationTransformer.transform("synthetic_gen/tasks/_src/instrument");
        }
        this.linuxMakeTransformer.transform();
        if (experimentalCodeSnippetMatching) {
            this.outputBuffer.appendTo("SRC", "synthetic_gen/labels/_src/labels", "");
            this.outputBuffer.appendTo("INC", "synthetic_gen/labels/_inc/labels", "");
            this.outputBuffer.appendTo("SRC", "synthetic_gen/codesnippets/_src/codesnippets", "");
            this.outputBuffer.appendTo("INC", "synthetic_gen/codesnippets/_inc/codesnippets", "");
        }
        this.outputBuffer.appendTo("SRC", "synthetic_gen/ticksUtils/_src/ticksUtils", "");
        this.outputBuffer.appendTo("INC", "synthetic_gen/ticksUtils/_inc/ticksUtils", "");
        this.outputBuffer.appendTo("SRC", "synthetic_gen/runnables/_src/runnables", "");
        this.outputBuffer.appendTo("INC", "synthetic_gen/runnables/_inc/runnables", "");
        this.outputBuffer.finish();
        this.logger.info("Finished Linux SLG code generation", new Object[0]);
    }
}

