/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.linux.transformers.sw;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.Group;
import org.eclipse.app4mc.amalthea.model.InterProcessStimulus;
import org.eclipse.app4mc.amalthea.model.InterProcessTrigger;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.StringObject;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.app4mc.amalthea.model.impl.CustomPropertyImpl;
import org.eclipse.app4mc.amalthea.model.util.DeploymentUtil;
import org.eclipse.app4mc.slg.commons.m2t.CustomObjectsStore;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.config.CodehookType;
import org.eclipse.app4mc.slg.config.ConfigModel;
import org.eclipse.app4mc.slg.config.util.ConfigModelUtils;
import org.eclipse.app4mc.slg.linux.generators.LinuxTaskGenerator;
import org.eclipse.app4mc.slg.linux.transformers.LinuxBaseTransformer;
import org.eclipse.emf.ecore.EObject;

@Singleton
public class LinuxTaskTransformer
extends LinuxBaseTransformer {
    @Inject
    private Properties properties;
    @Inject
    private CustomObjectsStore customObjsStore;
    private final Map<List<Object>, SLGTranslationUnit> transformCache = new HashMap<List<Object>, SLGTranslationUnit>();

    @Override
    public Map<List<Object>, SLGTranslationUnit> getCache() {
        return this.transformCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SLGTranslationUnit transform(Task task) {
        SLGTranslationUnit tu;
        ArrayList<Task> key = new ArrayList<Task>(Arrays.asList(task));
        Map<List<Object>, SLGTranslationUnit> map = this.transformCache;
        synchronized (map) {
            if (this.transformCache.containsKey(key)) {
                return this.transformCache.get(key);
            }
            tu = this.createTranslationUnit(task);
            this.transformCache.put(key, tu);
        }
        if (tu.isValid()) {
            this.doTransform(tu, task);
        }
        return tu;
    }

    private SLGTranslationUnit createTranslationUnit(Task task) {
        if (task == null) {
            return new SLGTranslationUnit("UNSPECIFIED TASK");
        }
        String basePath = "synthetic_gen";
        String moduleName = "tasks";
        String call = String.valueOf(task.getName()) + "()";
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    private void doTransform(SLGTranslationUnit tu, Task task) {
        this.genFiles(tu, task);
    }

    private void genFiles(SLGTranslationUnit tu, Task task) {
        boolean enableInstrumentation_R = Boolean.parseBoolean(this.properties.getProperty("enableInstrumentation_Runnables"));
        boolean enableExtCode = Boolean.parseBoolean(this.properties.getProperty("enableExternalCode"));
        boolean extOverwrite = false;
        Amalthea root = (Amalthea)AmaltheaServices.getContainerOfType((EObject)task, Amalthea.class);
        Set assignedCores = DeploymentUtil.getAssignedCoreForProcess((Process)task, (Amalthea)root);
        StringBuilder puDefinition = new StringBuilder("default");
        if (assignedCores != null && !assignedCores.isEmpty()) {
            puDefinition.delete(0, puDefinition.length());
            ProcessingUnit pu = (ProcessingUnit)assignedCores.iterator().next();
            ProcessingUnitDefinition puDef = pu.getDefinition();
            String puDefName = puDef == null ? null : puDef.getName();
            puDefinition.append(puDefName);
        }
        ArrayList<String> statements = new ArrayList<String>();
        ArrayList<Process> processedTasks = new ArrayList<Process>();
        ArrayList<String> statementsOverwrite = new ArrayList<String>();
        if (task != null && task.getActivityGraph() != null) {
            for (EObject item : task.getActivityGraph().eContents()) {
                if (item instanceof CustomPropertyImpl && enableExtCode) {
                    if (((CustomPropertyImpl)item).getKey().equals("codehook")) {
                        Value value = ((CustomPropertyImpl)item).getValue();
                        if (value instanceof StringObject) {
                            statements.add(String.valueOf(((StringObject)value).getValue()) + ";");
                        }
                    } else if (((CustomPropertyImpl)item).getKey().equals("codehook_overwrite")) {
                        extOverwrite = true;
                        Value value1 = ((CustomPropertyImpl)item).getValue();
                        if (value1 instanceof StringObject) {
                            statementsOverwrite.add(((StringObject)value1).getValue());
                        }
                    }
                }
                if (item instanceof Group) {
                    for (ActivityGraphItem item2 : ((Group)item).getItems()) {
                        if (item2 instanceof RunnableCall) {
                            Runnable runnable = ((RunnableCall)item2).getRunnable();
                            if (enableInstrumentation_R) {
                                statements.add("instrument_start_measurement(counter1);");
                                statements.add("run_" + runnable.getName() + "(\"" + puDefinition.toString() + "\");");
                                statements.add("instrument_stop_measurement(counter1); counter1++;");
                                continue;
                            }
                            statements.add("run_" + runnable.getName() + "(\"" + puDefinition.toString() + "\");");
                            continue;
                        }
                        if (!(item2 instanceof InterProcessTrigger)) continue;
                        InterProcessStimulus stimulus = ((InterProcessTrigger)item2).getStimulus();
                        LinuxTaskGenerator.handleInterProcessTrigger(statements, processedTasks, (Stimulus)stimulus);
                    }
                    continue;
                }
                if (item instanceof RunnableCall) {
                    Runnable runnable = ((RunnableCall)item).getRunnable();
                    if (runnable == null) continue;
                    if (enableInstrumentation_R) {
                        statements.add("instrument_start_measurement(counter1);");
                        statements.add("run_" + runnable.getName() + "(\"" + puDefinition.toString() + "\");");
                        statements.add("instrument_stop_measurement(counter1); counter1++;");
                        continue;
                    }
                    statements.add("run_" + runnable.getName() + "(\"" + puDefinition.toString() + "\");");
                    continue;
                }
                if (!(item instanceof InterProcessTrigger)) continue;
                InterProcessStimulus stimulus = ((InterProcessTrigger)item).getStimulus();
                LinuxTaskGenerator.handleInterProcessTrigger(statements, processedTasks, (Stimulus)stimulus);
            }
        }
        if (this.isIncFileEmpty(tu)) {
            ConfigModel configModel = (ConfigModel)this.customObjsStore.getInstance(ConfigModel.class);
            if (enableExtCode) {
                for (String hDir : ConfigModelUtils.getHeaderFilesDirectories((ConfigModel)configModel, (CodehookType)CodehookType.TASK)) {
                    File folder = new File(hDir.trim());
                    String names = ConfigModelUtils.getHeaderFilesIncludeMultiString((File)folder);
                    this.incAppend(tu, names);
                }
            }
            this.incAppend(tu, LinuxTaskGenerator.snippetIncStart());
        }
        if (this.isSrcFileEmpty(tu)) {
            this.srcAppend(tu, LinuxTaskGenerator.snippetSrcStart(enableInstrumentation_R));
        }
        if (extOverwrite) {
            String statement_overwrite = "void " + task.getName() + "(){ \n\n";
            this.srcAppend(tu, statement_overwrite);
            for (String statement : statementsOverwrite) {
                this.srcAppend(tu, String.valueOf(statement) + ";" + "\n");
            }
            this.srcAppend(tu, "\n}\n");
            this.srcAppend(tu, "\n void *" + task.getName() + "_entry(){ \n \n");
            this.srcAppend(tu, String.valueOf(task.getName()) + "(); \n");
            this.srcAppend(tu, "\n}\n");
        } else {
            this.srcAppend(tu, LinuxTaskGenerator.toCpp(task, statements));
        }
        this.incAppend(tu, LinuxTaskGenerator.toH(task));
    }
}

