/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.commons.m2t.transformers;

import com.google.inject.Inject;
import java.util.Properties;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.slg.commons.m2t.CustomObjectsStore;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGBaseTransformer;
import org.eclipse.app4mc.slg.config.ConfigModel;
import org.eclipse.app4mc.slg.config.util.ConfigurationFileLoader;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class AmaltheaModel2TextTransformer
extends SLGBaseTransformer {
    @Inject
    private SessionLogger logger;
    @Inject
    private Properties properties;
    @Inject
    private CustomObjectsStore customObjsStore;
    public ConfigModel configModel;

    public void transform(Amalthea model, String outputPath) {
    }

    public void m2tTransformation(ResourceSet inputResourceSet) {
        for (Resource resource : inputResourceSet.getResources()) {
            for (EObject model : resource.getContents()) {
                this.logger.info("Processing file : {0}", new Object[]{resource.getURI()});
                String outputFolder = this.getProperty("transformation_output_folder");
                String configurationFilePath = this.getProperty("configurationFile");
                if (configurationFilePath != null) {
                    try {
                        this.configModel = ConfigurationFileLoader.loadConfigurationFile((String)configurationFilePath);
                    }
                    catch (IllegalStateException e) {
                        this.logger.error(e.getMessage(), new Object[]{e});
                        return;
                    }
                } else {
                    this.logger.error("configuration file path is not supplied as a command line argument", new Object[0]);
                    return;
                }
                this.customObjsStore.injectMembers(ConfigModel.class, this.configModel);
                if (this.configModel == null) {
                    this.logger.error("As no configuration model is available , unable to proceed with the load generator application !!", new Object[0]);
                    return;
                }
                if (model instanceof Amalthea) {
                    this.transform((Amalthea)model, outputFolder);
                }
                this.logger.info("Script file generated at : {0}", new Object[]{outputFolder});
            }
        }
    }

    protected String getProperty(String propKey) {
        Object value = this.properties.get(propKey);
        if (value == null) {
            throw new NullPointerException("Request input key : \"" + propKey + "\" not supplied in the input properties file");
        }
        return value.toString();
    }

    protected String getProperty(String propKey, String defaultValue) {
        Object value = this.properties.get(propKey);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }
}

