/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.commons.m2t.transformers.sw;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation;
import org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition;
import org.eclipse.app4mc.amalthea.model.Ticks;
import org.eclipse.app4mc.slg.commons.m2t.generators.TicksGenerator;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGBaseTransformer;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.commons.m2t.transformers.sw.TicksUtilsTransformer;
import org.eclipse.emf.common.util.EMap;

@Singleton
public class TicksTransformer
extends SLGBaseTransformer {
    @Inject
    private TicksUtilsTransformer ticksUtilsTransformer;

    public SLGTranslationUnit transform(Ticks ticks) {
        if (ticks.getDefault() != null) {
            SLGTranslationUnit ticksUtilsTU = this.ticksUtilsTransformer.transform(ticks.getDefault());
            return this.createTranslationUnit(ticks, ticksUtilsTU, ticks.getDefault());
        }
        return null;
    }

    protected SLGTranslationUnit createTranslationUnit(Ticks ticks, SLGTranslationUnit ticksUtilsTU, IDiscreteValueDeviation value) {
        if (ticksUtilsTU == null) {
            return new SLGTranslationUnit("UNSPECIFIED TICKS");
        }
        String basePath = ticksUtilsTU.getBasePath();
        String moduleName = ticksUtilsTU.getModuleName();
        String call = this.computeCall(ticks, value);
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    protected String computeCall(Ticks ticks, IDiscreteValueDeviation value) {
        String parameters = TicksGenerator.getParameters(value);
        String className = value.eClass().getName();
        return "executeTicks_" + className + "(" + parameters + ")";
    }

    public Map<String, SLGTranslationUnit> transformAllItems(Ticks ticks) {
        HashMap<String, SLGTranslationUnit> result = new HashMap<String, SLGTranslationUnit>();
        IDiscreteValueDeviation defaultTicks = ticks.getDefault();
        if (defaultTicks != null) {
            SLGTranslationUnit ticksUtilsTU = this.ticksUtilsTransformer.transform(defaultTicks);
            result.put("default", this.createTranslationUnit(ticks, ticksUtilsTU, defaultTicks));
        }
        EMap extendedTicksMap = ticks.getExtended();
        for (Map.Entry entry : extendedTicksMap.entrySet()) {
            ProcessingUnitDefinition puDefinition = (ProcessingUnitDefinition)entry.getKey();
            IDiscreteValueDeviation ticksDeviation = (IDiscreteValueDeviation)entry.getValue();
            if (puDefinition == null || ticksDeviation == null) continue;
            SLGTranslationUnit ticksUtilsTU = this.ticksUtilsTransformer.transform(ticksDeviation);
            result.put(puDefinition.getName(), this.createTranslationUnit(ticks, ticksUtilsTU, ticksDeviation));
        }
        return result;
    }
}

