/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.commons.m2t.transformers.sw;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.slg.commons.m2t.generators.LabelGenerator;
import org.eclipse.app4mc.slg.commons.m2t.generators.TaskGenerator;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGBaseTransformer;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.commons.m2t.transformers.sw.LabelTransformer;
import org.eclipse.app4mc.slg.commons.m2t.transformers.sw.RunnableTransformer;
import org.eclipse.emf.common.util.EList;

@Singleton
public class TaskTransformer
extends SLGBaseTransformer {
    @Inject
    private RunnableTransformer runnableTransformer;
    @Inject
    private LabelTransformer labelTransformer;
    private final Map<List<Object>, SLGTranslationUnit> transformCache = new HashMap<List<Object>, SLGTranslationUnit>();

    @Override
    public Map<List<Object>, SLGTranslationUnit> getCache() {
        return this.transformCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SLGTranslationUnit transform(Task task) {
        SLGTranslationUnit tu;
        ArrayList<Task> key = new ArrayList<Task>(Arrays.asList(task));
        Map<List<Object>, SLGTranslationUnit> map = this.transformCache;
        synchronized (map) {
            if (this.transformCache.containsKey(key)) {
                return this.transformCache.get(key);
            }
            tu = this.createTranslationUnit(task);
            this.transformCache.put(key, tu);
        }
        if (tu.isValid()) {
            this.doTransform(tu, task);
        }
        return tu;
    }

    protected SLGTranslationUnit createTranslationUnit(Task task) {
        if (task == null) {
            return new SLGTranslationUnit("UNSPECIFIED TASK");
        }
        String basePath = "";
        String moduleName = task.getName();
        String call = task.getName() + "()";
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    protected void doTransform(SLGTranslationUnit tu, Task task) {
        this.genFiles(tu, task);
    }

    protected void genFiles(SLGTranslationUnit tu, Task task) {
        LinkedHashSet<String> includes = new LinkedHashSet<String>();
        LinkedList<String> initCalls = new LinkedList<String>();
        LinkedList<String> stepCalls = new LinkedList<String>();
        if (task != null && task.getActivityGraph() != null) {
            for (ActivityGraphItem activityGraphItem : task.getActivityGraph().getItems()) {
                if (!(activityGraphItem instanceof RunnableCall)) continue;
                Runnable runnable = ((RunnableCall)activityGraphItem).getRunnable();
                SLGTranslationUnit runnableTU = this.runnableTransformer.transform(runnable);
                includes.add(this.getIncFile(runnableTU));
                EList tags = ((RunnableCall)activityGraphItem).getTags();
                if (tags.stream().anyMatch(tag -> "initialize".equals(tag.getName()))) {
                    initCalls.add(runnableTU.getCall());
                    continue;
                }
                stepCalls.add(runnableTU.getCall());
            }
        }
        for (Map.Entry entry : this.labelTransformer.getCache().entrySet()) {
            if (!(((List)entry.getKey()).get(0) instanceof Label)) continue;
            Label label = (Label)entry.getKey();
            SLGTranslationUnit labelTU = (SLGTranslationUnit)entry.getValue();
            includes.add(this.getIncFile(labelTU));
            initCalls.add(LabelGenerator.initCall(label));
        }
        this.incAppend(tu, TaskGenerator.toH(tu));
        this.srcAppend(tu, TaskGenerator.toCpp(tu, this.getIncFile(tu), includes, initCalls, stepCalls));
    }
}

