/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.linux.transformers.stimuli;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.app4mc.amalthea.model.PeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.linux.generators.LinuxStimulusGenerator;
import org.eclipse.app4mc.slg.linux.transformers.LinuxBaseTransformer;

@Singleton
public class LinuxStimulusTransformer
extends LinuxBaseTransformer {
    @Inject
    private Properties properties;
    private final Map<List<Object>, SLGTranslationUnit> transformCache = new HashMap<List<Object>, SLGTranslationUnit>();

    @Override
    public Map<List<Object>, SLGTranslationUnit> getCache() {
        return this.transformCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SLGTranslationUnit transform(List<Stimulus> stimuli) {
        SLGTranslationUnit tu;
        ArrayList<List> key = new ArrayList<List>(Arrays.asList(stimuli));
        Map<List<Object>, SLGTranslationUnit> map = this.transformCache;
        synchronized (map) {
            if (this.transformCache.containsKey(key)) {
                return this.transformCache.get(key);
            }
            tu = this.createTranslationUnit(stimuli);
            this.transformCache.put(key, tu);
        }
        if (tu.isValid()) {
            this.doTransform(tu, stimuli);
        }
        return tu;
    }

    private SLGTranslationUnit createTranslationUnit(List<Stimulus> stimuli) {
        if (stimuli == null || stimuli.isEmpty()) {
            return new SLGTranslationUnit("UNSPECIFIED STIMULI");
        }
        String basePath = "Executable";
        String moduleName = "main";
        String call = "trigger<Stimuli>";
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    private void doTransform(SLGTranslationUnit tu, List<Stimulus> stimuli) {
        ArrayList<Stimulus> filteredStimuli = new ArrayList<Stimulus>();
        for (Stimulus stimulus : stimuli) {
            if (!(stimulus instanceof PeriodicStimulus)) continue;
            filteredStimuli.add(stimulus);
        }
        this.genFiles(tu, filteredStimuli);
    }

    private void genFiles(SLGTranslationUnit tu, List<Stimulus> stimuli) {
        Stimulus lastStimulus = stimuli.get(stimuli.size() - 1);
        boolean enableInstrumentation = Boolean.parseBoolean(this.properties.getProperty("enableInstrumentation_Tasks"));
        this.srcAppend(tu, LinuxStimulusGenerator.toSrc(stimuli, lastStimulus, enableInstrumentation));
    }
}

