/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.linux.transformers.sw;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.app4mc.amalthea.model.Ticks;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGBaseTransformer;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.linux.generators.LinuxTicksGenerator;
import org.eclipse.app4mc.slg.linux.transformers.sw.LinuxTicksUtilsTransformer;

@Singleton
public class LinuxTicksTransformer
extends SLGBaseTransformer {
    @Inject
    private LinuxTicksUtilsTransformer ticksUtilsTransformer;

    public SLGTranslationUnit transform(Ticks ticks) {
        if (ticks.getDefault() != null) {
            SLGTranslationUnit ticksUtilsTU = this.ticksUtilsTransformer.transform(ticks.getDefault());
            return this.createTranslationUnit(ticks, ticksUtilsTU);
        }
        return null;
    }

    protected SLGTranslationUnit createTranslationUnit(Ticks ticks, SLGTranslationUnit ticksUtilsTU) {
        if (ticksUtilsTU == null) {
            return new SLGTranslationUnit("UNSPECIFIED TICKS");
        }
        String basePath = ticksUtilsTU.getBasePath();
        String moduleName = ticksUtilsTU.getModuleName();
        String call = this.computeCall(ticks);
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    protected String computeCall(Ticks ticks) {
        String parameters = LinuxTicksGenerator.getParameters(ticks.getDefault());
        String className = ticks.getDefault().eClass().getName();
        return "executeTicks_" + className + "(" + parameters + ")";
    }
}

