/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.linux.transformers.sw;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation;
import org.eclipse.app4mc.slg.commons.m2t.CustomObjectsStore;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.config.ConfigModel;
import org.eclipse.app4mc.slg.linux.generators.LinuxTicksUtilsGenerator;
import org.eclipse.app4mc.slg.linux.transformers.LinuxBaseTransformer;

@Singleton
public class LinuxTicksUtilsTransformer
extends LinuxBaseTransformer {
    @Inject
    private CustomObjectsStore customObjsStore;
    private final Map<List<Object>, SLGTranslationUnit> transformCache = new HashMap<List<Object>, SLGTranslationUnit>();

    public SLGTranslationUnit transform(IDiscreteValueDeviation value) {
        return this.transformClass(value.getClass());
    }

    @Override
    public Map<List<Object>, SLGTranslationUnit> getCache() {
        return this.transformCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SLGTranslationUnit transformClass(Class<? extends IDiscreteValueDeviation> devClass) {
        SLGTranslationUnit tu;
        ArrayList<Class> key = new ArrayList<Class>(Arrays.asList(devClass));
        Map<List<Object>, SLGTranslationUnit> map = this.transformCache;
        synchronized (map) {
            if (this.transformCache.containsKey(key)) {
                return this.transformCache.get(key);
            }
            tu = this.createTranslationUnit(devClass);
            this.transformCache.put(key, tu);
        }
        if (tu.isValid()) {
            this.doTransform(tu, devClass);
        }
        return tu;
    }

    private SLGTranslationUnit createTranslationUnit(Class<? extends IDiscreteValueDeviation> devClass) {
        if (devClass == null) {
            return new SLGTranslationUnit("UNSPECIFIED TICKS");
        }
        String basePath = "synthetic_gen";
        String moduleName = "ticksUtils";
        String call = "burnTicks(<params>)";
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    private void doTransform(SLGTranslationUnit tu, Class<? extends IDiscreteValueDeviation> devClass) {
        this.genFiles(tu, devClass);
    }

    public void genFiles(SLGTranslationUnit tu, Class<? extends IDiscreteValueDeviation> devClass) {
        if (this.isIncFileEmpty(tu)) {
            this.toH(tu);
        }
        if (this.isSrcFileEmpty(tu)) {
            this.toCPP(tu);
        }
        this.srcAppend(tu, LinuxTicksUtilsGenerator.generateTicks(devClass));
        this.incAppend(tu, LinuxTicksUtilsGenerator.generateTicksDeclaration(devClass));
    }

    private void toCPP(SLGTranslationUnit tu) {
        this.srcAppend(tu, "#include \"" + this.getIncFile(tu) + "\"\n");
        ConfigModel configModel = (ConfigModel)this.customObjsStore.getInstance(ConfigModel.class);
        String ticksCodeSnippet = configModel.getCustomTickImpl().getValue();
        boolean ticksCodeEnabled = configModel.getCustomTickImpl().isEnable();
        String burnTicksBody = ticksCodeEnabled ? ticksCodeSnippet : LinuxTicksUtilsGenerator.burnTicksDefault();
        this.srcAppend(tu, LinuxTicksUtilsGenerator.burnTicks(burnTicksBody));
        this.srcAppend(tu, LinuxTicksUtilsGenerator.burnTicksStatistics(configModel));
    }

    private void toH(SLGTranslationUnit tu) {
        this.incAppend(tu, LinuxTicksUtilsGenerator.burnTicksDeclaration());
        this.incAppend(tu, LinuxTicksUtilsGenerator.burnTicksStatisticsDecleration());
    }
}

