/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.transformation.starter;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.app4mc.transformation.TransformationDefinition;
import org.eclipse.app4mc.transformation.TransformationProcessor;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class AbstractTransformationStarter
implements EventHandler {
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected boolean isInteractive = false;
    protected TransformationProcessor transformationProcessor;

    protected void startTransformation(String[] args, List<TransformationDefinition> definitions) {
        if (args != null && args.length > 0) {
            String propertiesFilePath = null;
            String workingDirectory = null;
            String input = null;
            String output = null;
            String m2m = null;
            String m2t = null;
            HashMap<String, String> additional = new HashMap<String, String>();
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                if (arg.startsWith("-p") || arg.startsWith("--properties")) {
                    propertiesFilePath = args[++i];
                } else if (arg.startsWith("-w") || arg.startsWith("--workingDirectory")) {
                    workingDirectory = args[++i];
                } else if (arg.startsWith("-o") || arg.startsWith("--output")) {
                    output = args[++i];
                } else if (arg.startsWith("-m") || arg.startsWith("--m2m")) {
                    m2m = args[++i];
                } else if (arg.startsWith("-t") || arg.startsWith("--m2t")) {
                    m2t = args[++i];
                } else if (arg.startsWith("-A")) {
                    String argument = arg.substring(2);
                    String[] argArray = argument.split("=");
                    additional.put(argArray[0], argArray[1]);
                } else if (arg.startsWith("/?") || arg.startsWith("-h") || arg.startsWith("--help")) {
                    System.out.println();
                    System.out.println("Transformation configured via Properties file:");
                    System.out.println("[-p, --properties <file>] [-w, --workingDirectory <dir>]");
                    System.out.println();
                    System.out.println("Transformation configured via parameter:");
                    System.out.println("[-o, --output <dir>] [-m, --m2m <keys>] [-t, --m2t <keys>] [-A<key-value>] <directory>");
                    System.out.println();
                    System.out.println("Options:");
                    System.out.println("\t-p, --properties  \tThe Properties file that should be used to configure the transformation.");
                    System.out.println("\t\t\tIf the properties option is not set, the input needs to be provided as parameter.");
                    System.out.println();
                    System.out.println("\t-w, --workingDirectory\tThe working directory. Used to resolve file parameters in the Properties file in a relative manner. [optional].");
                    System.out.println();
                    System.out.println("\t-o, --output\tThe directory in which the output should be generated. Only interpreted if --properties is not set. [optional].");
                    System.out.println("\t\t\tIf not provided the output directory defaults to <input_directory>/result.");
                    System.out.println();
                    System.out.println("\t-m, --m2m\tComma separated list of m2m transformation keys [optional].");
                    System.out.println("\t\t\tIf not provided and no m2t transformation keys are set, all available m2m transformations will be executed.");
                    System.out.println();
                    System.out.println("\t-t, --m2t\tComma separated list of m2t transformation keys [optional].");
                    System.out.println("\t\t\tIf not provided and no m2m transformation keys are set, all available m2t transformations will be executed.");
                    System.out.println();
                    System.out.println("\t-A\t\tOption to provide additional transformation specific properties. [optional].");
                    System.out.println("\t\t\tNeed to be provided in the key=value format.");
                    System.out.println();
                    System.out.println("\t-h, --help, /?\tShow this help.");
                    System.out.println();
                    System.out.println("Parameter:");
                    System.out.println("\tdirectory\tThe directory that contains model files to transform");
                    System.out.println();
                    System.out.println("Available M2M transformations:");
                    System.out.println(this.getAvailableM2MKeys(definitions));
                    System.out.println("Available M2T transformations:");
                    System.out.println(this.getAvailableM2TKeys(definitions));
                    System.exit(0);
                } else if (!arg.startsWith("-") && arg.trim().length() > 0) {
                    input = arg;
                }
                ++i;
            }
            if (propertiesFilePath != null && !propertiesFilePath.isEmpty()) {
                File propertiesFile = new File(propertiesFilePath);
                if (!propertiesFile.exists()) {
                    if (workingDirectory != null) {
                        propertiesFile = new File(workingDirectory, propertiesFilePath);
                        if (!propertiesFile.exists()) {
                            System.err.println("input properties file doesn't seem to exist. Check the value of command line parameter '--properties'");
                            System.exit(0);
                        }
                    } else {
                        System.err.println("input properties file doesn't seem to exist, also '--workingDirectory' commandline parameter is not supplied");
                        System.exit(0);
                    }
                } else {
                    try {
                        this.transformationProcessor.startTransformation(propertiesFile, workingDirectory);
                    }
                    catch (Exception e) {
                        System.err.println("Error in transformation setup: " + e.getMessage());
                        e.printStackTrace();
                        System.exit(0);
                    }
                }
            } else if (input != null && !input.isEmpty()) {
                Properties properties = new Properties();
                properties.put("input_models_folder", input);
                if (output == null || output.isEmpty()) {
                    Path inputPath = Paths.get(input, new String[0]);
                    output = inputPath.resolve("result").toString();
                }
                properties.put("output_folder", output);
                if ((m2m == null || m2m.isEmpty()) && (m2t == null || m2t.isEmpty())) {
                    m2m = this.getAvailableM2MKeys(definitions);
                    m2t = this.getAvailableM2TKeys(definitions);
                }
                if (m2m != null && !m2m.isEmpty()) {
                    properties.put("m2mTransformers", m2m);
                }
                if (m2t != null && !m2t.isEmpty()) {
                    properties.put("m2tTransformers", m2t);
                }
                if (!additional.isEmpty()) {
                    properties.putAll((Map<?, ?>)additional);
                }
                this.transformationProcessor.startTransformation(properties);
            } else {
                System.err.println("Model transformation can not be performed as neither Properties file nor input path is supplied");
                System.exit(0);
            }
        }
    }

    private String getAvailableM2MKeys(List<TransformationDefinition> definitions) {
        List keys = definitions.stream().filter(def -> def.getM2MKey() != null).map(TransformationDefinition::getM2MKey).collect(Collectors.toList());
        return String.join((CharSequence)",", keys);
    }

    private String getAvailableM2TKeys(List<TransformationDefinition> definitions) {
        List keys = definitions.stream().filter(def -> def.getM2TKey() != null).map(TransformationDefinition::getM2TKey).collect(Collectors.toList());
        return String.join((CharSequence)",", keys);
    }

    public void handleEvent(Event event) {
        if (this.started.get() && !this.isInteractive && event.getProperty("cm.factoryPid").equals("TRANSFORMATION_SESSION_CONFIG")) {
            System.exit(0);
        }
    }
}

