/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.transformation.starter;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.transformation.TransformationDefinition;
import org.eclipse.app4mc.transformation.TransformationProcessor;
import org.eclipse.app4mc.transformation.starter.AbstractTransformationStarter;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventHandler;

@Component(immediate=true, property={"event.topics=org/osgi/service/cm/ConfigurationEvent/CM_DELETED"}, service={EventHandler.class})
public class BndTransformationStarter
extends AbstractTransformationStarter {
    String[] launcherArgs;
    @Reference
    List<TransformationDefinition> definitions;

    @Reference(target="(launcher.arguments=*)")
    void setLauncherArguments(Object object, Map<String, Object> map) {
        this.launcherArgs = (String[])map.get("launcher.arguments");
    }

    @Reference
    void setTransformationProcessor(TransformationProcessor transformationProcessor) {
        this.transformationProcessor = transformationProcessor;
    }

    @Activate
    void activate() {
        String console = System.getProperty("osgi.console");
        this.isInteractive = console != null && console.length() == 0;
        String[] args = (String[])Arrays.stream(this.launcherArgs).filter(arg -> !"-console".equals(arg) && !"-consoleLog".equals(arg)).toArray(String[]::new);
        if (this.started.compareAndSet(false, true)) {
            this.startTransformation(args, this.definitions);
        }
    }
}

