/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.transformation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.app4mc.transformation.registry.TransformerRegistry;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.event.EventHandler;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;
import org.osgi.util.tracker.ServiceTracker;

@Component(service={TransformationProcessor.class})
public class TransformationProcessor {
    LoggerFactory factory;
    Logger logger;
    @Reference
    ConfigurationAdmin configAdmin;
    @Reference(target="(component.factory=org.eclipse.app4mc.amalthea.sessionlog.factory)")
    ComponentFactory<SessionLogger> loggerFactory;
    ServiceRegistration<?> eventHandlerRegistration;
    HashMap<String, ComponentInstance<SessionLogger>> sessionLoggerMap = new HashMap();
    BundleContext context;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    void setLogger(LoggerFactory factory) {
        this.factory = factory;
        this.logger = factory.getLogger(this.getClass());
    }

    void unsetLogger(LoggerFactory loggerFactory) {
        if (this.factory == loggerFactory) {
            this.factory = null;
            this.logger = null;
        }
    }

    @Activate
    void activate(BundleContext context) {
        this.context = context;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("event.topics", "org/eclipse/app4mc/transformation/DONE");
        this.eventHandlerRegistration = context.registerService(EventHandler.class.getName(), event -> {
            String sessionName = event.containsProperty("SESSION_ID") ? event.getProperty("SESSION_ID").toString() : null;
            this.cleanup(sessionName);
        }, properties);
    }

    @Deactivate
    void deactivate() {
        if (this.eventHandlerRegistration != null) {
            this.eventHandlerRegistration.unregister();
        }
    }

    public void startTransformation(File propertiesFile) {
        this.startTransformation(propertiesFile, null);
    }

    public void startTransformation(File propertiesFile, String workingDirectory) {
        try {
            Properties inputParameters = this.getInputParameter(propertiesFile, workingDirectory);
            this.startTransformation(inputParameters, false);
        }
        catch (IOException e) {
            this.logger.error("Error in extracting properties from provided input file", (Object)e);
        }
    }

    public void startTransformation(Properties inputParameters) {
        this.startTransformation(inputParameters, true);
    }

    private void startTransformation(Properties inputParameters, boolean harmonize) {
        block16: {
            if (inputParameters != null) {
                try {
                    String name2;
                    Object workingDirectoryPath = inputParameters.get("workingDirectory");
                    File rootDir = null;
                    if (workingDirectoryPath != null && !workingDirectoryPath.toString().trim().equals("")) {
                        rootDir = new File(workingDirectoryPath.toString());
                    }
                    Properties params = harmonize ? this.harmonizeInputParameter(inputParameters, rootDir) : inputParameters;
                    Hashtable<String, Object> dictionaryForConfiguration = new Hashtable<String, Object>();
                    for (String name2 : params.stringPropertyNames()) {
                        String value = params.getProperty(name2);
                        dictionaryForConfiguration.put(name2, value);
                    }
                    name2 = params.getProperty("SESSION_ID");
                    if (name2 == null) {
                        name2 = "single";
                        dictionaryForConfiguration.put("SESSION_ID", name2);
                    }
                    String servicePid = "TRANSFORMATION_SESSION_CONFIG~" + name2;
                    String pidFilter = "(service.pid=" + servicePid + ")";
                    String factoryPidFilter = "(service.factoryPid=TRANSFORMATION_SESSION_CONFIG)";
                    String filter = "(&" + pidFilter + factoryPidFilter + ")";
                    Configuration[] existing = this.configAdmin.listConfigurations(filter);
                    if (existing == null || existing.length == 0) {
                        String m2tTransformersKey;
                        String[] m2tKeys;
                        String[] m2mKeys;
                        Hashtable<String, String> sessionLoggerDictionary = new Hashtable<String, String>();
                        sessionLoggerDictionary.put("SESSION_ID", name2);
                        ComponentInstance sessionLoggerInstance = this.loggerFactory.newInstance(sessionLoggerDictionary);
                        this.sessionLoggerMap.put(name2, (ComponentInstance<SessionLogger>)sessionLoggerInstance);
                        SessionLogger sessionLogger = (SessionLogger)sessionLoggerInstance.getInstance();
                        String m2mTransformersKey = (String)params.get("m2mTransformers");
                        String[] stringArray = m2mKeys = m2mTransformersKey != null ? m2mTransformersKey.split(",") : new String[]{};
                        if (m2mKeys.length > 0) {
                            String m2mFilter = "";
                            String[] stringArray2 = m2mKeys;
                            int n = m2mKeys.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String key = stringArray2[n2];
                                m2mFilter = String.valueOf(m2mFilter) + "(m2mTransformers=" + key + ")";
                                ++n2;
                            }
                            if (m2mKeys.length > 1) {
                                m2mFilter = "(|" + m2mFilter + ")";
                            }
                            m2mFilter = "(&" + pidFilter + m2mFilter + ")";
                            dictionaryForConfiguration.put("m2mTransformers.target", m2mFilter);
                            dictionaryForConfiguration.put("m2mTransformers.cardinality.minimum", m2mKeys.length);
                        }
                        String[] stringArray3 = m2tKeys = (m2tTransformersKey = (String)params.get("m2tTransformers")) != null ? m2tTransformersKey.split(",") : new String[]{};
                        if (m2tKeys.length > 0) {
                            String m2tFilter = "";
                            String[] stringArray4 = m2tKeys;
                            int n = m2tKeys.length;
                            int n3 = 0;
                            while (n3 < n) {
                                String key = stringArray4[n3];
                                m2tFilter = String.valueOf(m2tFilter) + "(transformation=" + key + ")";
                                ++n3;
                            }
                            if (m2tKeys.length > 1) {
                                m2tFilter = "(|" + m2tFilter + ")";
                            }
                            m2tFilter = "(&" + pidFilter + m2tFilter + ")";
                            dictionaryForConfiguration.put("m2tTransformers.target", m2tFilter);
                            dictionaryForConfiguration.put("m2tTransformers.cardinality.minimum", m2tKeys.length);
                        }
                        dictionaryForConfiguration.put("sessionLogger.target", "(SESSION_ID=" + name2 + ")");
                        Configuration configuration = this.configAdmin.getFactoryConfiguration("TRANSFORMATION_SESSION_CONFIG", name2, "?");
                        configuration.update(dictionaryForConfiguration);
                        TransformerRegistry transformerRegistry = this.getTransformerRegistry(pidFilter);
                        if (transformerRegistry != null) {
                            transformerRegistry.startTransformation();
                        } else {
                            StringBuilder errorBuilder = new StringBuilder("Failed to create TransformerRegistry. Double check the transformer configuration.").append(System.lineSeparator()).append(System.lineSeparator());
                            dictionaryForConfiguration.entrySet().stream().filter(entry -> "m2mTransformers".equals(entry.getKey()) || "m2tTransformers".equals(entry.getKey())).forEach(entry -> {
                                StringBuilder stringBuilder2 = errorBuilder.append((String)entry.getKey()).append(" : ").append(entry.getValue()).append(System.lineSeparator());
                            });
                            errorBuilder.append(System.lineSeparator());
                            sessionLogger.error(errorBuilder.toString(), new Object[0]);
                            sessionLogger.flush(new File((String)params.get("log_file")));
                            this.cleanup(name2);
                        }
                        break block16;
                    }
                    this.logger.error("Transformation configuration for session id {} is already available.", (Object)servicePid);
                }
                catch (IOException | InvalidSyntaxException e) {
                    this.logger.error("Error in retrieving existing session configurations", (Object)e);
                }
            } else {
                this.logger.error("ERROR !! Unable to start transformation as required parameters are not set in input properties file");
            }
        }
    }

    private TransformerRegistry getTransformerRegistry(String pidFilter) {
        try {
            String filterString = "(&(objectClass=" + TransformerRegistry.class.getName() + ")" + pidFilter + ")";
            Filter filter = this.context.createFilter(filterString);
            ServiceTracker st = new ServiceTracker(this.context, filter, null);
            st.open();
            return (TransformerRegistry)st.waitForService(1000L);
        }
        catch (InterruptedException | InvalidSyntaxException e) {
            this.logger.error("Failed to get TransformerRegistry", (Object)e);
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private void cleanup(String sessionName) {
        block3: {
            if (this.sessionLoggerMap.containsKey(sessionName)) {
                this.sessionLoggerMap.get(sessionName).dispose();
            }
            try {
                Configuration configuration = this.configAdmin.getFactoryConfiguration("TRANSFORMATION_SESSION_CONFIG", sessionName, "?");
                configuration.delete();
            }
            catch (IOException e) {
                if (this.logger == null) break block3;
                this.logger.error("Failed to delete the session configuration", (Object)e);
            }
        }
    }

    private Properties getInputParameter(File propertiesFile, String workingDirectory) throws IOException {
        Properties properties = new Properties();
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileInputStream fis = new FileInputStream(propertiesFile);){
            properties.load(fis);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        File workDir = null;
        if (workingDirectory != null && !workingDirectory.isEmpty()) {
            properties.put("workingDirectory", workingDirectory);
            workDir = new File(workingDirectory);
        } else {
            String dir = properties.getProperty("workingDirectory");
            if (dir != null && !dir.isEmpty()) {
                workDir = new File(dir);
            }
        }
        if (workDir == null) {
            workDir = propertiesFile.getAbsoluteFile().getParentFile();
            if (!properties.contains("workingDirectory")) {
                properties.put("workingDirectory", workDir.getPath());
            }
        }
        return this.harmonizeInputParameter(properties, workDir);
    }

    private Properties harmonizeInputParameter(Properties properties, File rootFolder) {
        Object inputModelsFolder = properties.get("input_models_folder");
        Object outputFolder = properties.get("output_folder");
        File inputFile = null;
        if (inputModelsFolder != null) {
            String path = inputModelsFolder.toString();
            inputFile = new File(path);
            if (inputFile.exists()) {
                properties.put("input_models_folder", path);
            } else if (rootFolder != null && (inputFile = new File(rootFolder, path)).exists()) {
                properties.put("input_models_folder", inputFile.getAbsolutePath());
            }
        } else {
            throw new IllegalArgumentException("'input_models_folder' parameter needs to be set");
        }
        if (!inputFile.exists()) {
            throw new IllegalArgumentException("'input_models_folder' doesn't seem to exist. Please check configuration of 'input_models_folder' and optional 'workingDirectory'.");
        }
        if (rootFolder == null) {
            rootFolder = inputFile.getParentFile();
        }
        if (outputFolder != null) {
            Path outputFolderPath = Paths.get(outputFolder.toString(), new String[0]);
            properties.put("m2m_output_folder", Paths.get(outputFolderPath.toString(), "m2m_output_models").toString());
            properties.put("m2t_output_folder", Paths.get(outputFolderPath.toString(), "m2t_output_text_files").toString());
            properties.put("log_file", Paths.get(outputFolderPath.toString(), "transformation.log").toString());
        }
        Object m2mOutputFolder = properties.get("m2m_output_folder");
        Object m2tOutputFolder = properties.get("m2t_output_folder");
        Object logFile = properties.get("log_file");
        if (m2mOutputFolder == null) {
            throw new IllegalArgumentException("'m2m_output_folder' parameter needs to be set");
        }
        String path = m2mOutputFolder.toString();
        String newPath = new File(path).isAbsolute() ? path : new File(rootFolder, path).getAbsolutePath();
        properties.put("m2m_output_folder", newPath);
        if (m2tOutputFolder == null) {
            throw new IllegalArgumentException("'m2t_output_folder' parameter needs to be set");
        }
        path = m2tOutputFolder.toString();
        newPath = new File(path).isAbsolute() ? path : new File(rootFolder, path).getAbsolutePath();
        properties.put("m2t_output_folder", newPath);
        if (logFile != null) {
            path = logFile.toString();
            newPath = new File(path).isAbsolute() ? path : new File(rootFolder, path).getAbsolutePath();
            properties.put("log_file", newPath);
        }
        return properties;
    }
}

