/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.commons.m2t.transformers.sw;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.Group;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.commons.m2t.transformers.sw.ActivityGraphItemTransformer;

@Singleton
public class GroupSourceTransformer
extends ActivityGraphItemTransformer {
    @Inject
    private ActivityGraphItemTransformer activityGraphItemTransformer;
    private final Map<List<Object>, SLGTranslationUnit> transformCache = new HashMap<List<Object>, SLGTranslationUnit>();

    @Override
    public Map<List<Object>, SLGTranslationUnit> getCache() {
        return this.transformCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SLGTranslationUnit transform(Group group) {
        SLGTranslationUnit tu;
        ArrayList<Group> key = new ArrayList<Group>(Arrays.asList(group));
        Map<List<Object>, SLGTranslationUnit> map = this.transformCache;
        synchronized (map) {
            if (this.transformCache.containsKey(key)) {
                return this.transformCache.get(key);
            }
            tu = this.createTranslationUnit(group);
            this.transformCache.put(key, tu);
        }
        if (tu.isValid()) {
            this.doTransform(tu, group);
        }
        return tu;
    }

    protected SLGTranslationUnit createTranslationUnit(Group group) {
        if (group == null) {
            return new SLGTranslationUnit("UNSPECIFIED GROUP");
        }
        String basePath = "groups";
        String moduleName = "groups";
        String call = "group_" + group.getName() + "()";
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    protected void doTransform(SLGTranslationUnit tu, Group group) {
        this.genFiles(tu, group);
    }

    protected void genFiles(SLGTranslationUnit tu, Group group) {
        if (group == null) {
            return;
        }
        LinkedList<String> groupItemIncludes = new LinkedList<String>();
        LinkedList<String> groupItemCalls = new LinkedList<String>();
        for (ActivityGraphItem item : group.getItems()) {
            SLGTranslationUnit tmpTU = this.activityGraphItemTransformer.transform(item);
            if (!tmpTU.isValid()) continue;
            groupItemIncludes.add(this.getIncPath(tmpTU));
            groupItemCalls.add(tmpTU.getCall());
        }
        this.srcAppend(tu, "\n//Group " + group.getName() + "----\n");
        for (String include : groupItemIncludes) {
            this.srcAppend(tu, "#include \"" + include + ".h\"\n");
        }
        this.srcAppend(tu, "void " + tu.getCall() + "{\n");
        for (String call : groupItemCalls) {
            this.srcAppend(tu, String.valueOf(call) + ";\n");
        }
        this.srcAppend(tu, "}");
    }
}

