/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.commons.m2t.generators;

import org.eclipse.xtend2.lib.StringConcatenation;

public class InstrumentationGenerator {
    private InstrumentationGenerator() {
        throw new IllegalStateException("Utility class");
    }

    public static String getHeaderFileContent() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include <stdlib.h>");
        _builder.newLine();
        _builder.append("#include <stdio.h>");
        _builder.newLine();
        _builder.append("#include <unistd.h>");
        _builder.newLine();
        _builder.append("#include <string.h>");
        _builder.newLine();
        _builder.append("#include <sys/ioctl.h>");
        _builder.newLine();
        _builder.append("#include <linux/perf_event.h>");
        _builder.newLine();
        _builder.append("#include <asm/unistd.h>");
        _builder.newLine();
        _builder.append("#include <inttypes.h>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void instrument_start(int* fd, pid_t pid, uint64_t event_list[], int total_events);");
        _builder.newLine();
        _builder.append("void instrument_stop(int* fd);");
        _builder.newLine();
        _builder.append("void instrument_read(int* fd);");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void instr_start(void);");
        _builder.newLine();
        _builder.append("void instr_stop(void);");
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }

    public static String getSourceFileContent() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include \"instrument.h\"");
        _builder.newLine();
        _builder.append("#define LOGFILE \"output.log\"");
        _builder.newLine();
        _builder.append("int unique_global_fd[7];");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void instr_start(void){");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("uint64_t event_list[] = {0x08, 0x12, 0x04, 0x03, 0x16, 0x17};");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int total_events =  sizeof(event_list)/sizeof(event_list[0]);");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("instrument_start(unique_global_fd, 0, event_list, total_events);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void instr_stop(void){");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("instrument_stop(unique_global_fd);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("static int perf_event_define(pid_t proccess_id, int group_fd, uint64_t pinned, uint32_t event_type, uint64_t event)");
        _builder.newLine();
        _builder.append("{\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("struct perf_event_attr hw_event;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("pid_t pid = proccess_id; \t    // measure the current process/thread");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int cpu = -1; \t                // measure on any cpu");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("unsigned long flags = 0;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int fd_current;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("memset(&hw_event, 0, sizeof(struct perf_event_attr));");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("hw_event.type = event_type;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("hw_event.size = sizeof(struct perf_event_attr);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("hw_event.config = event;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("hw_event.disabled = 1;          // off by default. specifies whether the counter starts out disabled or enabled.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("hw_event.exclude_kernel = 1; \t// excluding events that happen in the kernel-space");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("hw_event.exclude_hv = 1;      \t// excluding events that happen in the hypervisor");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("hw_event.pinned = pinned;\t\t// specifies the counter to be on the CPU if at all possible. applies only to hardware counters and only to group leaders.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("hw_event.exclude_user = 0; \t\t//  excludes events that happen in user space");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("hw_event.exclude_callchain_kernel  = 1; // Do not include kernel callchains.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("hw_event.exclude_callchain_user = 0;\t// Do not include user callchains.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// hw_event.inherit = 1;\t\t// Inherit does not work for some combinations of read_format values, such as PERF_FORMAT_GROUP.");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//hw_event.exclusive = 1;\t\t// not working for counters other than cycle counter");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("//hw_event.exclude_idle = 1; \t// doesn't work");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("hw_event.read_format = PERF_FORMAT_GROUP; // Allows all counter values in an event group to be read with one read");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("fd_current = syscall(__NR_perf_event_open, &hw_event, pid, cpu, group_fd, flags);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (fd_current == -1) {");
        _builder.newLine();
        _builder.append("\t  ");
        _builder.append("printf(\"Error opening leader %llx\\n\", hw_event.config);");
        _builder.newLine();
        _builder.append("\t  ");
        _builder.append("exit(EXIT_FAILURE);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("   ");
        _builder.append("return fd_current;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void instrument_start(int* fd, pid_t pid, uint64_t event_list[], int total_events){");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int i;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("fd[0] = perf_event_define(pid, -1, 1, PERF_TYPE_HARDWARE, PERF_COUNT_HW_CPU_CYCLES);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (i = 0; i < total_events; i++){");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("fd[i+1] = perf_event_define(pid, fd[0], 0, PERF_TYPE_RAW, event_list[i]);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* Example usage:");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("perf_event_define(fd, 0, PERF_TYPE_RAW, 0x0008);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("perf_event_define(fd, 0, PERF_TYPE_RAW, 0x0012);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("perf_event_define(fd, 0, PERF_TYPE_RAW, 0x0004);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("perf_event_define(fd, 0, PERF_TYPE_RAW, 0x0003);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("perf_event_define(fd, 0, PERF_TYPE_RAW, 0x0016);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("perf_event_define(fd, 0, PERF_TYPE_RAW, 0x0017);");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int fd = perf_event_define(-1, 1, PERF_TYPE_HARDWARE, PERF_COUNT_HW_CPU_CYCLES);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("perf_event_define(fd, 0, PERF_TYPE_HARDWARE, PERF_COUNT_HW_INSTRUCTIONS);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("perf_event_define(fd, 0, PERF_TYPE_HARDWARE, PERF_COUNT_HW_BRANCH_INSTRUCTIONS);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("perf_event_define(fd , 0, PERF_TYPE_HARDWARE, PERF_COUNT_HW_CACHE_REFERENCES);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("perf_event_define(fd , 0, PERF_TYPE_HARDWARE, PERF_COUNT_HW_CACHE_MISSES);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("perf_event_define(fd , 0, PERF_TYPE_HW_CACHE, (PERF_COUNT_HW_CACHE_LL) | (PERF_COUNT_HW_CACHE_OP_READ << 8) | (PERF_COUNT_HW_CACHE_RESULT_ACCESS << 16));");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("perf_event_define(fd , 0, PERF_TYPE_HW_CACHE, (PERF_COUNT_HW_CACHE_LL) | (PERF_COUNT_HW_CACHE_OP_READ << 8) | (PERF_COUNT_HW_CACHE_RESULT_MISS << 16));");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ioctl(fd[0], PERF_EVENT_IOC_RESET, PERF_IOC_FLAG_GROUP);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ioctl(fd[0], PERF_EVENT_IOC_ENABLE, PERF_IOC_FLAG_GROUP);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("struct read_format {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("uint64_t nr; \t\t// The number of events");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("struct {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("uint64_t value; // The value of the event");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("} values[];");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void instrument_stop(int* fd){");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ioctl(fd[0], PERF_EVENT_IOC_DISABLE, PERF_IOC_FLAG_GROUP);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("char buf[4096];");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("read(fd[0], buf, sizeof(buf));");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int i;\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("struct read_format* rf = (struct read_format*) buf;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (i = 0; i < rf->nr+1; i++){");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("close(*(fd+i));");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("FILE * file_pointer;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("file_pointer = fopen(\"output.log\", \"a\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (file_pointer != NULL) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for (i = 0; i < rf->nr; i++)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("fprintf(file_pointer, \"%\" PRId64 \"\\t\", rf->values[i].value);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("fprintf(file_pointer, \"\\n\");");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("fclose(file_pointer);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("else{");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("printf(\"File Pointer Error\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("void instrument_read(int* fd){");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("char buf[4096];");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("read(fd[0], buf, sizeof(buf));");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("int i;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("struct read_format* rf = (struct read_format*) buf;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("FILE * file_pointer;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("file_pointer = fopen(\"output.log\", \"a\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (i = 0; i < rf->nr; i++)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("fprintf(file_pointer, \"%\" PRId64 \"\\t\", rf->values[i].value);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("fprintf(file_pointer, \"\\n\");");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("fclose(file_pointer);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("ioctl(fd[0], PERF_EVENT_IOC_RESET, PERF_IOC_FLAG_GROUP);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        return _builder.toString();
    }
}

