/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FileType implements Enumerator
{
    UNDEFINED(-1, "UNDEFINED", "UNDEFINED"),
    C(1, "c", "c"),
    H(2, "h", "h"),
    CPP(3, "cpp", "cpp"),
    HPP(4, "hpp", "hpp");

    public static final String copyright = "*******************************************************************************\n Copyright (c) 2020 Robert Bosch GmbH and others.\n\n This program and the accompanying materials are made\n available under the terms of the Eclipse Public License 2.0\n which is available at https://www.eclipse.org/legal/epl-2.0/\n\n SPDX-License-Identifier: EPL-2.0\n\n    Generated using Eclipse EMF\n\n*******************************************************************************";
    public static final int UNDEFINED_VALUE = -1;
    public static final int C_VALUE = 1;
    public static final int H_VALUE = 2;
    public static final int CPP_VALUE = 3;
    public static final int HPP_VALUE = 4;
    private static final FileType[] VALUES_ARRAY;
    public static final List<FileType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FileType[]{UNDEFINED, C, H, CPP, HPP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FileType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FileType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FileType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FileType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FileType get(int value) {
        switch (value) {
            case -1: {
                return UNDEFINED;
            }
            case 1: {
                return C;
            }
            case 2: {
                return H;
            }
            case 3: {
                return CPP;
            }
            case 4: {
                return HPP;
            }
        }
        return null;
    }

    private FileType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

