/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PlatformArchitecture implements Enumerator
{
    X86_64(0, "x86_64", "x86_64"),
    X86_32(1, "x86_32", "x86_32"),
    AARCH64(2, "aarch64", "aarch64");

    public static final String copyright = "*******************************************************************************\n Copyright (c) 2020 Robert Bosch GmbH and others.\n\n This program and the accompanying materials are made\n available under the terms of the Eclipse Public License 2.0\n which is available at https://www.eclipse.org/legal/epl-2.0/\n\n SPDX-License-Identifier: EPL-2.0\n\n    Generated using Eclipse EMF\n\n*******************************************************************************";
    public static final int X86_64_VALUE = 0;
    public static final int X86_32_VALUE = 1;
    public static final int AARCH64_VALUE = 2;
    private static final PlatformArchitecture[] VALUES_ARRAY;
    public static final List<PlatformArchitecture> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PlatformArchitecture[]{X86_64, X86_32, AARCH64};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PlatformArchitecture get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PlatformArchitecture result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PlatformArchitecture getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PlatformArchitecture result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PlatformArchitecture get(int value) {
        switch (value) {
            case 0: {
                return X86_64;
            }
            case 1: {
                return X86_32;
            }
            case 2: {
                return AARCH64;
            }
        }
        return null;
    }

    private PlatformArchitecture(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

