/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.ros2.transformers.sw;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.app4mc.amalthea.model.InterProcessTrigger;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.ros2.transformers.sw.RosInterProcessTriggerUtilsTransformer;

@Singleton
public class RosInterProcessTriggerTransformer {
    @Inject
    private RosInterProcessTriggerUtilsTransformer iptUtilTransformer;

    public SLGTranslationUnit transform(InterProcessTrigger ipt) {
        SLGTranslationUnit utilTU = this.iptUtilTransformer.transform(ipt);
        return this.createTranslationUnit(ipt, utilTU);
    }

    private SLGTranslationUnit createTranslationUnit(InterProcessTrigger ipt, SLGTranslationUnit utilTU) {
        if (ipt == null) {
            return new SLGTranslationUnit("UNSPECIFIED INTER PROCESS TRIGGER");
        }
        String basePath = utilTU.getBasePath();
        String moduleName = utilTU.getModuleName();
        String call = this.computeCall(ipt);
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    private String computeCall(InterProcessTrigger ipt) {
        String param = ipt.getStimulus().getName();
        return "call_service_" + param + "(" + param + "_client)";
    }
}

