/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.ros2.transformers.sw;

import com.google.inject.Singleton;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;

@Singleton
public class RosRunnableCache {
    private Map<SLGTranslationUnit, RunnableStore> cache = new HashMap<SLGTranslationUnit, RunnableStore>();

    public RunnableStore getStore(SLGTranslationUnit tu) {
        return this.cache.get(tu);
    }

    public void storeValues(SLGTranslationUnit tu, Runnable runnable, String param, String nodeParam, Collection<String> publishers, Collection<String> clientDeclarations, Collection<String> clientInits) {
        RunnableStore store = new RunnableStore(runnable, param, nodeParam, publishers, clientDeclarations, clientInits);
        this.cache.put(tu, store);
    }

    public class RunnableStore {
        private final Runnable runnable;
        private final String param;
        private final String nodeParam;
        private final Collection<String> publishers;
        private final Collection<String> clientDeclarations;
        private final Collection<String> clientInits;

        public RunnableStore(Runnable runnable, String param, String nodeParam, Collection<String> publishers, Collection<String> clientDeclarations, Collection<String> clientInits) {
            this.runnable = runnable;
            this.param = param;
            this.nodeParam = nodeParam;
            this.publishers = publishers;
            this.clientDeclarations = clientDeclarations;
            this.clientInits = clientInits;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public String getParam() {
            return this.param;
        }

        public String getNodeParam() {
            return this.nodeParam;
        }

        public Collection<String> getPublishers() {
            return this.publishers;
        }

        public Collection<String> getClientDeclarations() {
            return this.clientDeclarations;
        }

        public Collection<String> getClientInits() {
            return this.clientInits;
        }

        public String getCall() {
            return "run_" + this.runnable.getName() + "(" + this.param + ")";
        }

        public String getNodeCall() {
            return "run_" + this.runnable.getName() + "(" + this.nodeParam + ")";
        }
    }
}

