/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.commons.m2t;

import java.util.Collection;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.ActivityGraph;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.BooleanObject;
import org.eclipse.app4mc.amalthea.model.DataSize;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.ModeSwitch;
import org.eclipse.app4mc.amalthea.model.ModeSwitchDefault;
import org.eclipse.app4mc.amalthea.model.ModeSwitchEntry;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

public class AmaltheaModelUtils {
    private AmaltheaModelUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static ModeSwitchEntry getModeSwitchEntryForCase(ActivityGraph activityGraph, String caseValue) {
        EList items = activityGraph.getItems();
        for (ActivityGraphItem ActivityGraphItem2 : items) {
            if (!(ActivityGraphItem2 instanceof ModeSwitch)) continue;
            EList entries = ((ModeSwitch)ActivityGraphItem2).getEntries();
            for (ModeSwitchEntry modeSwitchEntry : entries) {
                if (!modeSwitchEntry.getName().equals(caseValue)) continue;
                return modeSwitchEntry;
            }
        }
        return null;
    }

    public static EList<ActivityGraphItem> getAllActivityGraphItems(ActivityGraph activityGraph) {
        BasicEList basicEList = new BasicEList();
        EList items = activityGraph.getItems();
        basicEList.addAll((Collection)items);
        for (ActivityGraphItem ActivityGraphItem2 : items) {
            if (!(ActivityGraphItem2 instanceof ModeSwitch)) continue;
            EList entries = ((ModeSwitch)ActivityGraphItem2).getEntries();
            for (ModeSwitchEntry modeSwitchEntry : entries) {
                EList modeSwitchEntriesActivityGraphItems = modeSwitchEntry.getItems();
                basicEList.addAll((Collection)modeSwitchEntriesActivityGraphItems);
            }
        }
        return basicEList;
    }

    public static long getDataSizeInBytes(LabelAccess labelAccess) {
        DataSize size;
        Label data = labelAccess.getData();
        if (data != null && (size = data.getSize()) != null) {
            return size.getNumberBytes();
        }
        return 0L;
    }

    public static long getLabelArraySize(Label label) {
        DataSize size;
        if (label != null && (size = label.getSize()) != null) {
            long numberBytes = size.getNumberBytes();
            return numberBytes / 4L;
        }
        return 0L;
    }

    public static Set<Label> getAllLabelsUsedInTask(Task amltTask, Set<Label> labels) {
        ActivityGraph activityGraph = amltTask.getActivityGraph();
        if (activityGraph != null) {
            EList items = activityGraph.getItems();
            AmaltheaModelUtils.populateLabels(labels, (EList<ActivityGraphItem>)items);
        }
        return labels;
    }

    private static void populateLabels(Set<Label> labels, EList<ActivityGraphItem> items) {
        for (ActivityGraphItem ActivityGraphItem2 : items) {
            ActivityGraph activityGraph;
            Runnable runnable;
            if (ActivityGraphItem2 instanceof LabelAccess) {
                Label data = ((LabelAccess)ActivityGraphItem2).getData();
                if (data == null) continue;
                labels.add(data);
                continue;
            }
            if (ActivityGraphItem2 instanceof ModeSwitch) {
                ModeSwitchDefault defaultEntry = ((ModeSwitch)ActivityGraphItem2).getDefaultEntry();
                if (defaultEntry != null) {
                    EList items2 = defaultEntry.getItems();
                    AmaltheaModelUtils.populateLabels(labels, (EList<ActivityGraphItem>)items2);
                }
                EList entries = ((ModeSwitch)ActivityGraphItem2).getEntries();
                for (ModeSwitchEntry modeSwitchEntry : entries) {
                    EList items2 = modeSwitchEntry.getItems();
                    AmaltheaModelUtils.populateLabels(labels, (EList<ActivityGraphItem>)items2);
                }
                continue;
            }
            if (!(ActivityGraphItem2 instanceof RunnableCall) || (runnable = ((RunnableCall)ActivityGraphItem2).getRunnable()) == null || (activityGraph = runnable.getActivityGraph()) == null) continue;
            AmaltheaModelUtils.populateLabels(labels, (EList<ActivityGraphItem>)activityGraph.getItems());
        }
    }

    public static boolean isInitializePropertySet(RunnableCall runnableCall) {
        String key;
        EMap customProperties = runnableCall.getCustomProperties();
        Value value = (Value)customProperties.get((Object)(key = "initialize"));
        if (value instanceof BooleanObject) {
            return ((BooleanObject)value).isValue();
        }
        return false;
    }
}

