/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.commons.m2t.transformers.sw;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.app4mc.amalthea.model.ActivityGraph;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.StringObject;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.app4mc.amalthea.model.impl.CustomPropertyImpl;
import org.eclipse.app4mc.slg.commons.m2t.CustomObjectsStore;
import org.eclipse.app4mc.slg.commons.m2t.generators.RunnableGenerator;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGBaseTransformer;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.commons.m2t.transformers.sw.ActivityGraphItemTransformer;
import org.eclipse.app4mc.slg.config.CodehookType;
import org.eclipse.app4mc.slg.config.ConfigModel;
import org.eclipse.app4mc.slg.config.util.ConfigModelUtils;
import org.eclipse.app4mc.transformation.util.OutputBuffer;
import org.eclipse.emf.ecore.EObject;

@Singleton
public class RunnableTransformer
extends SLGBaseTransformer {
    @Inject
    private OutputBuffer outputBuffer;
    @Inject
    private ActivityGraphItemTransformer activityGraphItemTransformer;
    @Inject
    private CustomObjectsStore customObjsStore;
    @Inject
    private Properties properties;
    private static final String RUNNABLE_TITLE_START = "\n//Runnable ";
    private static final String RUNNABLE_TITLE_END = "----\n";
    private static final String VOID = "void ";
    private final Map<List<Object>, SLGTranslationUnit> transformCache = new HashMap<List<Object>, SLGTranslationUnit>();

    @Override
    public Map<List<Object>, SLGTranslationUnit> getCache() {
        return this.transformCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SLGTranslationUnit transform(Runnable runnable) {
        SLGTranslationUnit tu;
        ArrayList<Runnable> key = new ArrayList<Runnable>(Arrays.asList(runnable));
        Map<List<Object>, SLGTranslationUnit> map = this.transformCache;
        synchronized (map) {
            if (this.transformCache.containsKey(key)) {
                return this.transformCache.get(key);
            }
            tu = this.createTranslationUnit(runnable);
            this.transformCache.put(key, tu);
        }
        if (tu.isValid()) {
            this.doTransform(tu, runnable);
        }
        return tu;
    }

    protected SLGTranslationUnit createTranslationUnit(Runnable runnable) {
        if (runnable == null) {
            return new SLGTranslationUnit("UNSPECIFIED RUNNABLE");
        }
        String basePath = "synthetic_gen";
        String moduleName = "runnables";
        String call = "run_" + runnable.getName() + "()";
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    protected void doTransform(SLGTranslationUnit tu, Runnable runnable) {
        this.genFiles(tu, runnable);
    }

    protected void genFiles(SLGTranslationUnit tu, Runnable runnable) {
        if (this.isSrcFileEmpty(tu)) {
            this.srcAppend(tu, "#include \"" + this.getIncFile(tu) + "\"\n");
        }
        boolean extOverwrite = false;
        LinkedHashSet<String> includes = new LinkedHashSet<String>();
        ArrayList<String> calls = new ArrayList<String>();
        ArrayList<String> callsOverwrite = new ArrayList<String>();
        if (runnable != null && runnable.getActivityGraph() != null) {
            extOverwrite = this.processCustomProperties(extOverwrite, calls, callsOverwrite, runnable.getActivityGraph());
            for (ActivityGraphItem item : runnable.getActivityGraph().getItems()) {
                String tmpCall;
                SLGTranslationUnit tmpTU = this.activityGraphItemTransformer.transform(item);
                String tmpIncFile = this.getIncFile(tmpTU);
                if (tmpIncFile != null && !tmpIncFile.isEmpty() && !tmpIncFile.equals(this.getIncFile(tu))) {
                    includes.add(tmpIncFile);
                }
                if ((tmpCall = tmpTU.getCall()) == null || tmpCall.isEmpty()) continue;
                calls.add(tmpCall);
            }
        }
        this.incAppend(tu, RUNNABLE_TITLE_START + runnable.getName() + RUNNABLE_TITLE_END);
        this.toH(tu, runnable.getName(), includes);
        this.srcAppend(tu, RUNNABLE_TITLE_START + runnable.getName() + RUNNABLE_TITLE_END);
        if (extOverwrite) {
            this.srcAppend(tu, VOID + tu.getCall() + "{\n");
            for (String call : callsOverwrite) {
                this.srcAppend(tu, String.valueOf(call) + ";" + "\n");
            }
            this.srcAppend(tu, "\n}\n");
        } else {
            this.toCpp(tu, calls);
        }
    }

    protected boolean processCustomProperties(boolean extOverwrite, List<String> calls, List<String> callsOverwrite, ActivityGraph activityGraph) {
        for (EObject item : activityGraph.eContents()) {
            boolean enableExtCode;
            if (!(item instanceof CustomPropertyImpl) || !(enableExtCode = Boolean.parseBoolean(this.properties.getProperty("enableExternalCode")))) continue;
            if (((CustomPropertyImpl)item).getKey().equals("codehook")) {
                Value value = ((CustomPropertyImpl)item).getValue();
                if (!(value instanceof StringObject)) continue;
                calls.add(((StringObject)value).getValue());
                continue;
            }
            if (!((CustomPropertyImpl)item).getKey().equals("codehook_overwrite")) continue;
            extOverwrite = true;
            Value value1 = ((CustomPropertyImpl)item).getValue();
            if (!(value1 instanceof StringObject)) continue;
            callsOverwrite.add(((StringObject)value1).getValue());
        }
        return extOverwrite;
    }

    protected void toH(SLGTranslationUnit tu, String runnableName, HashSet<String> includes) {
        if (this.isIncFileEmpty(tu)) {
            ConfigModel configModel = (ConfigModel)this.customObjsStore.getInstance(ConfigModel.class);
            boolean enableExtCode = Boolean.parseBoolean(this.properties.getProperty("enableExternalCode"));
            if (enableExtCode) {
                for (String hDir : ConfigModelUtils.getHeaderFilesDirectories((ConfigModel)configModel, (CodehookType)CodehookType.RUNNABLE)) {
                    File folder = new File(hDir.trim());
                    String names = ConfigModelUtils.getHeaderFilesIncludeMultiString((File)folder);
                    this.incAppend(tu, names);
                }
            }
            this.incAppend(tu, "#include <string.h>\n");
            for (String include : includes) {
                this.incAppend(tu, "#include \"" + include + "\"\n");
            }
        }
        this.incAppend(tu, RUNNABLE_TITLE_START + runnableName + RUNNABLE_TITLE_END);
        this.incAppend(tu, VOID + tu.getCall() + "(char* coreName);\n");
    }

    protected void toCpp(SLGTranslationUnit tu, List<String> calls) {
        this.srcAppend(tu, VOID + tu.getCall() + "{\n");
        for (String call : calls) {
            this.srcAppend(tu, "\t" + call + ";\n");
        }
        this.srcAppend(tu, "}\n\n");
    }

    public boolean createCMake() {
        String makeFilePath = "synthetic_gen/runnables/CMakeLists.txt";
        return this.outputBuffer.appendTo("OTHER", makeFilePath, RunnableGenerator.toCMake(this.getSrcFiles()));
    }
}

