/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.commons.m2t.transformers.sw;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.IDiscreteValueDeviation;
import org.eclipse.app4mc.slg.commons.m2t.CustomObjectsStore;
import org.eclipse.app4mc.slg.commons.m2t.generators.TicksUtilsGenerator;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGBaseTransformer;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.config.ConfigModel;
import org.eclipse.app4mc.slg.config.PlatformArchitecture;
import org.eclipse.app4mc.transformation.util.OutputBuffer;
import org.eclipse.emf.ecore.EClass;

@Singleton
public class TicksUtilsTransformer
extends SLGBaseTransformer {
    @Inject
    private OutputBuffer outputBuffer;
    @Inject
    private CustomObjectsStore customObjsStore;
    private final Map<List<Object>, SLGTranslationUnit> transformCache = new HashMap<List<Object>, SLGTranslationUnit>();

    public SLGTranslationUnit transform(IDiscreteValueDeviation value) {
        if (value == null) {
            return new SLGTranslationUnit("UNSPECIFIED TICKS");
        }
        return this.transformClass(value.eClass());
    }

    @Override
    public Map<List<Object>, SLGTranslationUnit> getCache() {
        return this.transformCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SLGTranslationUnit transformClass(EClass eClass) {
        SLGTranslationUnit tu;
        ArrayList<EClass> key = new ArrayList<EClass>(Arrays.asList(eClass));
        Map<List<Object>, SLGTranslationUnit> map = this.transformCache;
        synchronized (map) {
            if (this.transformCache.containsKey(key)) {
                return this.transformCache.get(key);
            }
            tu = this.createTranslationUnit(eClass);
            this.transformCache.put(key, tu);
        }
        if (tu.isValid()) {
            this.doTransform(tu, eClass);
        }
        return tu;
    }

    protected SLGTranslationUnit createTranslationUnit(EClass eClass) {
        if (eClass == null) {
            return new SLGTranslationUnit("UNSPECIFIED TICKS");
        }
        String basePath = "synthetic_gen";
        String moduleName = "ticksUtils";
        String call = "burnTicks(<params>)";
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    protected void doTransform(SLGTranslationUnit tu, EClass eClass) {
        this.genFiles(tu, eClass);
    }

    protected void genFiles(SLGTranslationUnit tu, EClass eClass) {
        if (this.isIncFileEmpty(tu)) {
            this.toH(tu);
        }
        if (this.isSrcFileEmpty(tu)) {
            this.toCPP(tu);
        }
        this.srcAppend(tu, TicksUtilsGenerator.generateTicks(eClass));
        this.incAppend(tu, TicksUtilsGenerator.generateTicksDeclaration(eClass));
    }

    protected void toCPP(SLGTranslationUnit tu) {
        this.srcAppend(tu, "#include \"" + this.getIncFile(tu) + "\"\n");
        ConfigModel configModel = (ConfigModel)this.customObjsStore.getInstance(ConfigModel.class);
        PlatformArchitecture platformArchitectureType = configModel.getPlatformArchitectureType();
        if (platformArchitectureType != null) {
            this.srcAppend(tu, "#define __" + platformArchitectureType.getName() + "__\n");
        }
        String ticksCodeSnippet = configModel.getCustomTickImpl().getValue();
        boolean ticksCodeEnabled = configModel.getCustomTickImpl().isEnable();
        String burnTicksBody = ticksCodeEnabled ? ticksCodeSnippet : TicksUtilsGenerator.burnTicksDefault();
        this.srcAppend(tu, TicksUtilsGenerator.burnTicks(burnTicksBody));
        this.srcAppend(tu, TicksUtilsGenerator.burnTicksStatistics(configModel));
    }

    protected void toH(SLGTranslationUnit tu) {
        this.incAppend(tu, TicksUtilsGenerator.burnTicksDeclaration());
        this.incAppend(tu, TicksUtilsGenerator.burnTicksStatisticsDeclaration());
    }

    public void createCMake() {
        String makeFilePath = "synthetic_gen/ticksUtils/CMakeLists.txt";
        this.outputBuffer.appendTo("OTHER", makeFilePath, TicksUtilsGenerator.toCMake(this.getSrcFiles()));
    }
}

