/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.ros2.generators;

import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.xtend2.lib.StringConcatenation;

public class RosRunnableGenerator {
    private RosRunnableGenerator() {
        throw new IllegalStateException("Utility class");
    }

    public static String toCMake(String libName, List<String> srcFiles) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# ");
        _builder.append(libName);
        _builder.append(" ################################################################");
        _builder.newLineIfNotEmpty();
        _builder.append("####");
        _builder.newLine();
        _builder.append("add_library(");
        _builder.append(libName);
        _builder.append(" STATIC");
        _builder.newLineIfNotEmpty();
        for (String srcFile : srcFiles) {
            _builder.append("\t${CMAKE_CURRENT_LIST_DIR}/_src/");
            _builder.append(srcFile);
            _builder.newLineIfNotEmpty();
        }
        _builder.append(")");
        _builder.newLine();
        _builder.newLine();
        _builder.append("target_include_directories(");
        _builder.append(libName);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("PUBLIC  ${CMAKE_CURRENT_LIST_DIR}/_inc");
        _builder.newLine();
        _builder.append(")");
        _builder.newLine();
        _builder.newLine();
        _builder.append("target_include_directories(");
        _builder.append(libName);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("PUBLIC ${CMAKE_CURRENT_LIST_DIR}/../ticksUtils/_inc");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("${CMAKE_CURRENT_LIST_DIR}/../labels/_inc");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("${CMAKE_CURRENT_LIST_DIR}/../channelSendUtils/_inc");
        _builder.newLine();
        _builder.append(")");
        _builder.newLine();
        _builder.newLine();
        _builder.append("target_link_libraries(RUNNABLES_LIB ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("PRIVATE LABELS_LIB TICKS_UTILS CHANNELSEND_UTILS");
        _builder.newLine();
        _builder.append(")");
        _builder.newLine();
        return _builder.toString();
    }

    public static String toH(String call, HashSet<String> includes) {
        String _xblockexpression = null;
        final StringBuilder builder = new StringBuilder();
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String include) {
                builder.append("#include \"" + include + "\"\n");
            }
        };
        includes.forEach(_function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        _builder.append(call);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        builder.append((CharSequence)_builder);
        _xblockexpression = builder.toString();
        return _xblockexpression;
    }

    public static String toCpp(Runnable runnable, HashSet<String> includes, String call, List<String> calls, boolean measure_performance) {
        String _xblockexpression = null;
        final StringBuilder builder = new StringBuilder();
        builder.append("void " + call + "{\n");
        if (measure_performance) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("uint64_t event_list[] = {0x11, 0x13, 0x17}; //CPU CYCLES, MEM ACCESS, L2 Cache Refill");
            _builder.newLine();
            _builder.append("int total_events =  sizeof(event_list)/sizeof(event_list[0]);");
            _builder.newLine();
            _builder.append("int fd = instrument_start(0,event_list, total_events);");
            _builder.newLine();
            builder.append((CharSequence)_builder);
        }
        Consumer<String> _function = new Consumer<String>(){

            @Override
            public void accept(String c) {
                builder.append("\t" + c + ";\n");
            }
        };
        calls.forEach(_function);
        if (measure_performance) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("instrument_stop(fd, \"");
            String _name = runnable.getName();
            _builder_1.append(_name);
            _builder_1.append(".log\");");
            _builder_1.newLineIfNotEmpty();
            builder.append((CharSequence)_builder_1);
        }
        builder.append("}\n\n");
        _xblockexpression = builder.toString();
        return _xblockexpression;
    }
}

