/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.ros2.generators;

import java.util.HashSet;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.StringObject;
import org.eclipse.app4mc.amalthea.model.Tag;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.xtend2.lib.StringConcatenation;

public class RosTagGenerator {
    private RosTagGenerator() {
        throw new IllegalStateException("Utility class");
    }

    public static String toCpp(Tag tag, String moduleName, HashSet<String> headers, List<String> declarations, List<String> inits, List<String> calls, List<String> serviceCallbacks) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include <chrono>");
        _builder.newLine();
        _builder.append("#include <memory>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"rclcpp/rclcpp.hpp\"");
        _builder.newLine();
        _builder.append("#include \"std_msgs/msg/string.hpp\"");
        _builder.newLine();
        _builder.append("\t\t\t\t\t\t\t  ");
        _builder.newLine();
        for (String header : headers) {
            _builder.append(header);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("using namespace std::chrono_literals;");
        _builder.newLine();
        _builder.append("using std::placeholders::_1;");
        _builder.newLine();
        _builder.newLine();
        for (String serviceCallback : serviceCallbacks) {
            _builder.append(serviceCallback);
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("class ");
        _builder.append(moduleName);
        _builder.append(" : public rclcpp::Node");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("private:");
        _builder.newLine();
        for (String declaration : declarations) {
            _builder.append("  ");
            _builder.append(declaration, "  ");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public:");
        _builder.newLine();
        _builder.append("\t  ");
        _builder.append(moduleName, "\t  ");
        _builder.append("()");
        _builder.newLineIfNotEmpty();
        _builder.append("\t  ");
        _builder.append(": Node(\"");
        String _lowerCase = moduleName.toLowerCase();
        _builder.append(_lowerCase, "\t  ");
        _builder.append("\")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t  ");
        _builder.append("{");
        _builder.newLine();
        for (String init : inits) {
            _builder.append("\t  \t");
            _builder.append(init, "\t  \t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t  \t");
        _builder.newLine();
        _builder.append("\t  \t");
        _builder.append("}");
        _builder.newLine();
        for (String call : calls) {
            _builder.append("\t  \t");
            _builder.append(call, "\t  \t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t  \t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("};");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("int main(int argc, char * argv[])");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("{\t\t  ");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("setvbuf(stdout, NULL, _IONBF, BUFSIZ);");
        _builder.newLine();
        _builder.append("\t\t   ");
        _builder.append("rclcpp::init(argc, argv);");
        _builder.newLine();
        Value _get = (Value)tag.getCustomProperties().get((Object)"executor_type");
        boolean bl = _tripleNotEquals = _get != null;
        if (_tripleNotEquals) {
            Value _get_1 = (Value)tag.getCustomProperties().get((Object)"executor_type");
            boolean _equals = ((StringObject)_get_1).getValue().equals("single_thread");
            if (_equals) {
                _builder.append("\t\t   ");
                _builder.append("rclcpp::executors::SingleThreadedExecutor executor;");
                _builder.newLine();
            } else {
                _builder.append("\t\t   ");
                _builder.append("rclcpp::executors::MultiThreadedExecutor executor;");
                _builder.newLine();
            }
        } else {
            _builder.append("\t\t   ");
            _builder.append("rclcpp::executors::MultiThreadedExecutor executor;");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("auto node = std::make_shared<");
        _builder.append(moduleName, "\t\t  ");
        _builder.append(">();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("executor.add_node(node);");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("executor.spin();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("rclcpp::shutdown();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t  ");
        _builder.append("return 0;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }
}

