/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.ros2.transformers.sw;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.app4mc.amalthea.model.ChannelSend;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.ros2.transformers.sw.RosChannelSendUtilsTransformer;

@Singleton
public class RosChannelSendTransformer {
    @Inject
    private RosChannelSendUtilsTransformer channelSendUtilTransformer;

    public SLGTranslationUnit transform(ChannelSend cs) {
        SLGTranslationUnit utilTU = this.channelSendUtilTransformer.transform(cs);
        return this.createTranslationUnit(cs, utilTU);
    }

    private SLGTranslationUnit createTranslationUnit(ChannelSend cs, SLGTranslationUnit utilTU) {
        if (cs == null) {
            return new SLGTranslationUnit("UNSPECIFIED CHANNEL SEND");
        }
        String basePath = utilTU.getBasePath();
        String moduleName = utilTU.getModuleName();
        String call = this.computeCall(cs);
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    private String computeCall(ChannelSend cs) {
        String param = cs.getData().getName();
        return "publish_to_" + param + "(" + param + "_publisher)";
    }
}

