/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.ros2.transformers.sw;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.ChannelSend;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.ros2.generators.RosChannelSendUtilsGenerator;
import org.eclipse.app4mc.slg.ros2.transformers.RosBaseTransformer;

@Singleton
public class RosChannelSendUtilsTransformer
extends RosBaseTransformer {
    public static final String LIB_NAME = "CHANNELSEND_UTIL";
    public static final String BASE_PATH = "synthetic_gen";
    public static final String MODULE_NAME = "channelSendUtils";
    public static final String MODULE_PATH = "synthetic_gen/channelSendUtils";
    public static final String MAKEFILE_PATH = "synthetic_gen/channelSendUtils/CMakeLists.txt";
    private List<String> topicList = new ArrayList<String>();
    private final Map<List<Object>, SLGTranslationUnit> transformCache = new HashMap<List<Object>, SLGTranslationUnit>();

    @Override
    public Map<List<Object>, SLGTranslationUnit> getCache() {
        return this.transformCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SLGTranslationUnit transform(ChannelSend cs) {
        SLGTranslationUnit tu;
        ArrayList<ChannelSend> key = new ArrayList<ChannelSend>(Arrays.asList(cs));
        Map<List<Object>, SLGTranslationUnit> map = this.transformCache;
        synchronized (map) {
            if (this.transformCache.containsKey(key)) {
                return this.transformCache.get(key);
            }
            tu = this.createTranslationUnit(cs);
            this.transformCache.put(key, tu);
        }
        if (tu.isValid()) {
            this.doTransform(tu, cs);
        }
        return tu;
    }

    private SLGTranslationUnit createTranslationUnit(ChannelSend cs) {
        if (cs == null) {
            return new SLGTranslationUnit("UNSPECIFIED CHANNEL SEND");
        }
        String basePath = BASE_PATH;
        String moduleName = MODULE_NAME;
        String call = "";
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    private void doTransform(SLGTranslationUnit tu, ChannelSend cs) {
        this.genFiles(tu, cs);
    }

    private void genFiles(SLGTranslationUnit tu, ChannelSend cs) {
        if (this.isSrcFileEmpty(tu)) {
            this.incAppend(tu, RosChannelSendUtilsGenerator.toHeader());
        }
        if (this.isSrcFileEmpty(tu)) {
            this.srcAppend(tu, RosChannelSendUtilsGenerator.toCPPHead());
        }
        this.defineData(tu, cs);
    }

    private void defineData(SLGTranslationUnit tu, ChannelSend cs) {
        if (cs.getData() == null || cs.getData().getName() == null || cs.getData().getName().isEmpty()) {
            return;
        }
        String topic = cs.getData().getName();
        if (!this.topicList.contains(topic)) {
            this.incAppend(tu, RosChannelSendUtilsGenerator.toH(cs));
            this.srcAppend(tu, RosChannelSendUtilsGenerator.toCPP(cs));
            this.topicList.add(topic);
        }
    }
}

