/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.ros2.transformers.sw;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.InterProcessTrigger;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGBaseTransformer;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.ros2.generators.RosInterProcessTriggerUtilsGenerator;

@Singleton
public class RosInterProcessTriggerUtilsTransformer
extends SLGBaseTransformer {
    public static final String LIB_NAME = "INTERPROCESSTRIGGER_UTIL";
    public static final String BASE_PATH = "synthetic_gen";
    public static final String MODULE_NAME = "interProcessTriggerUtils";
    public static final String MODULE_PATH = "synthetic_gen/interProcessTriggerUtils";
    public static final String MAKEFILE_PATH = "synthetic_gen/interProcessTriggerUtils/CMakeLists.txt";
    private final Map<List<Object>, SLGTranslationUnit> transformCache = new HashMap<List<Object>, SLGTranslationUnit>();

    public Map<List<Object>, SLGTranslationUnit> getCache() {
        return this.transformCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SLGTranslationUnit transform(InterProcessTrigger ipt) {
        SLGTranslationUnit tu;
        ArrayList<InterProcessTrigger> key = new ArrayList<InterProcessTrigger>(Arrays.asList(ipt));
        Map<List<Object>, SLGTranslationUnit> map = this.transformCache;
        synchronized (map) {
            if (this.transformCache.containsKey(key)) {
                return this.transformCache.get(key);
            }
            tu = this.createTranslationUnit(ipt);
            this.transformCache.put(key, tu);
        }
        if (tu.isValid()) {
            this.doTransform(tu, ipt);
        }
        return tu;
    }

    protected SLGTranslationUnit createTranslationUnit(InterProcessTrigger ipt) {
        if (ipt == null) {
            return new SLGTranslationUnit("UNSPECIFIED INTER PROCESS TRIGGER");
        }
        String basePath = BASE_PATH;
        String moduleName = MODULE_NAME;
        String call = "";
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    protected void doTransform(SLGTranslationUnit tu, InterProcessTrigger ipt) {
        this.genFiles(tu, ipt);
    }

    protected void genFiles(SLGTranslationUnit tu, InterProcessTrigger ipt) {
        if (this.isSrcFileEmpty(tu)) {
            this.incAppend(tu, RosInterProcessTriggerUtilsGenerator.toHeader());
        }
        if (this.isSrcFileEmpty(tu)) {
            this.srcAppend(tu, RosInterProcessTriggerUtilsGenerator.toCPPHead());
        }
        this.incAppend(tu, RosInterProcessTriggerUtilsGenerator.toH(ipt));
        this.srcAppend(tu, RosInterProcessTriggerUtilsGenerator.toCPP(ipt));
    }
}

