/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.transformation.util;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;

public class FileHelper {
    private FileHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static void zipResult(String outputFolder, SessionLogger logger) throws IOException {
        FileHelper.zipResult(outputFolder, Collections.emptyList(), logger);
    }

    public static void zipResult(String outputFolder, List<Path> excludeDirs, SessionLogger logger) throws IOException {
        List sourceFiles;
        Object filesStream;
        Path sourceDir = Paths.get(outputFolder, new String[0]);
        Throwable throwable = null;
        Object var6_6 = null;
        try {
            filesStream = Files.walk(sourceDir, new FileVisitOption[0]);
            try {
                sourceFiles = filesStream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).filter(path -> !path.getFileName().startsWith(".")).filter(path -> !path.getFileName().endsWith("result.zip")).filter(path -> excludeDirs.stream().noneMatch(path::startsWith)).collect(Collectors.toList());
            }
            finally {
                if (filesStream != null) {
                    filesStream.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Path outputFile = Paths.get(outputFolder, "result.zip");
        if (Files.exists(outputFile, new LinkOption[0])) {
            Files.delete(outputFile);
        }
        Path zipFile = Files.createFile(outputFile, new FileAttribute[0]);
        try {
            filesStream = null;
            Object var8_12 = null;
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));){
                for (Path path2 : sourceFiles) {
                    FileHelper.addFileToArchive(sourceDir, path2, zipOutputStream, logger);
                }
            }
            catch (Throwable throwable3) {
                if (filesStream == null) {
                    filesStream = throwable3;
                } else if (filesStream != throwable3) {
                    ((Throwable)filesStream).addSuppressed(throwable3);
                }
                throw filesStream;
            }
        }
        catch (Exception e) {
            logger.error("Failed to produce result zip archive", new Object[]{e});
        }
    }

    private static void addFileToArchive(Path sourceDir, Path file, ZipOutputStream zipOutputStream, SessionLogger logger) {
        try {
            ZipEntry zipEntry = new ZipEntry(sourceDir.relativize(file).toString());
            zipOutputStream.putNextEntry(zipEntry);
            Files.copy(file, zipOutputStream);
            zipOutputStream.closeEntry();
        }
        catch (IOException e) {
            logger.error("Failed to include {0} to zip archive", new Object[]{file.getFileName(), e});
        }
    }
}

