/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.ros2.generators;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.DataSize;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class RosLabelGenerator {
    private RosLabelGenerator() {
        throw new IllegalStateException("Utility class");
    }

    public static String initCall(String labelName) {
        return RosLabelGenerator.initCall(labelName, "_CacheLine* array,int array_elements");
    }

    public static String initCall(String labelName, String param) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("initialize_");
        _builder.append(labelName);
        _builder.append("(");
        _builder.append(labelName);
        _builder.append(param);
        _builder.append(")");
        return _builder.toString();
    }

    public static String readCall(String labelName, String param) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("read_");
        _builder.append(labelName);
        _builder.append("(");
        _builder.append(param);
        _builder.append(")");
        return _builder.toString();
    }

    public static String writeCall(String labelName, String param) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("write_");
        _builder.append(labelName);
        _builder.append("(");
        _builder.append(param);
        _builder.append(")");
        return _builder.toString();
    }

    public static String toCMake(String libName, List<String> srcFiles) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("# ");
        _builder.append(libName);
        _builder.append(" ################################################################");
        _builder.newLineIfNotEmpty();
        _builder.append("####");
        _builder.newLine();
        _builder.append("add_library(");
        _builder.append(libName);
        _builder.append("  STATIC");
        _builder.newLineIfNotEmpty();
        for (String srcFile : srcFiles) {
            _builder.append("\t${CMAKE_CURRENT_LIST_DIR}/_src/");
            _builder.append(srcFile);
            _builder.newLineIfNotEmpty();
        }
        _builder.append(")");
        _builder.newLine();
        _builder.newLine();
        _builder.append("target_include_directories(");
        _builder.append(libName);
        _builder.newLineIfNotEmpty();
        _builder.append("\t    ");
        _builder.append("PUBLIC ${CMAKE_CURRENT_LIST_DIR}/_inc");
        _builder.newLine();
        _builder.append(")\t");
        _builder.newLine();
        return _builder.toString();
    }

    public static String toH(Label label) {
        boolean _isNullOrEmpty;
        String _xblockexpression = null;
        String _xifexpression = null;
        String _name = null;
        if (label != null) {
            _name = label.getName();
        }
        _xifexpression = (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) ? "<undefined label>" : label.getName();
        String name = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("typedef struct ");
        _builder.append(name);
        _builder.append("_CacheLine");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("struct ");
        _builder.append(name, "  ");
        _builder.append("_CacheLine* ptrCacheLine[8] ;");
        _builder.newLineIfNotEmpty();
        _builder.append("} ");
        _builder.append(name);
        _builder.append("_CacheLine ;");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        String _initCall = RosLabelGenerator.initCall(name, "_CacheLine* array, int array_elements");
        _builder.append(_initCall);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        String _readCall = RosLabelGenerator.readCall(name, "int labelAccessStatistics");
        _builder.append(_readCall);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("void ");
        String _writeCall = RosLabelGenerator.writeCall(name, "int labelAccessStatistics");
        _builder.append(_writeCall);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    public static String toCpp(Label label) {
        boolean _isNullOrEmpty;
        String _xblockexpression = null;
        String _xifexpression = null;
        String _name = null;
        if (label != null) {
            _name = label.getName();
        }
        _xifexpression = (_isNullOrEmpty = StringExtensions.isNullOrEmpty(_name)) ? "<undefined label>" : label.getName();
        String name = _xifexpression;
        long _xifexpression_1 = 0L;
        DataSize _size = null;
        if (label != null) {
            _size = label.getSize();
        }
        boolean _tripleEquals = _size == null;
        _xifexpression_1 = _tripleEquals ? 0L : label.getSize().getNumberBytes();
        long numberOfBytes = _xifexpression_1;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void initialize_");
        _builder.append(name);
        _builder.append("(");
        _builder.append(name);
        _builder.append("_CacheLine* array,int array_elements) {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("int steps = array_elements / 2 ;");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("int bottom = 0 ;");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("int top = steps ;");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("int i = 0;");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("for (i = 0 ; i < steps ; i++) {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("array[bottom].ptrCacheLine[0] = &array[top] ;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("array[top].ptrCacheLine[0] = &array[bottom+1] ;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("top++ ;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("bottom++ ;");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("array[(array_elements-1)].ptrCacheLine[0] = NULL ;\t");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        String _readCall = RosLabelGenerator.readCall(label.getName(), "int labelAccessStatistics");
        _builder.append(_readCall);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("static bool initialized = false;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("int numberOfBytes = ");
        _builder.append((Object)numberOfBytes, "\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("static ");
        _builder.append(name, "\t\t");
        _builder.append("_CacheLine* ");
        _builder.append(name, "\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("if(!initialized) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("//init");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(name, "\t\t\t");
        _builder.append(" = (");
        _builder.append(name, "\t\t\t");
        _builder.append("_CacheLine*) malloc(sizeof(");
        _builder.append(name, "\t\t\t");
        _builder.append("_CacheLine) * 17000);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("initialize_");
        _builder.append(name, "\t\t\t");
        _builder.append("(");
        _builder.append(name, "\t\t\t");
        _builder.append(", 17000);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("initialized = true;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("static ");
        _builder.append(name, "\t\t");
        _builder.append("_CacheLine* i = ");
        _builder.append(name, "\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("static int counter = 0;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if(counter > 16100) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("counter = 0;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("i = ");
        _builder.append(name, "\t\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("int end_value = counter + numberOfBytes;");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("for(; counter < end_value; counter ++) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("i = i->ptrCacheLine[0];");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("void ");
        String _writeCall = RosLabelGenerator.writeCall(label.getName(), "int labelAccessStatistics");
        _builder.append(_writeCall);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("static bool initialized = false;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("int numberOfBytes = ");
        _builder.append((Object)numberOfBytes, "\t\t\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("static ");
        _builder.append(name, "\t\t\t\t");
        _builder.append("_CacheLine* ");
        _builder.append(name, "\t\t\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("if(!initialized) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("//init");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append(name, "\t\t\t\t\t");
        _builder.append(" = (");
        _builder.append(name, "\t\t\t\t\t");
        _builder.append("_CacheLine*) malloc(sizeof(");
        _builder.append(name, "\t\t\t\t\t");
        _builder.append("_CacheLine) * 17000);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t");
        _builder.append("initialize_");
        _builder.append(name, "\t\t\t\t\t");
        _builder.append("(");
        _builder.append(name, "\t\t\t\t\t");
        _builder.append(", 17000);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t");
        _builder.append("initialized = true;");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("static ");
        _builder.append(name, "\t\t\t\t");
        _builder.append("_CacheLine* i = ");
        _builder.append(name, "\t\t\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("static int counter = 0;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("if(counter > 16100) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("counter = 0;");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("i = ");
        _builder.append(name, "\t\t\t\t\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("int end_value = counter + numberOfBytes;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("for(; counter < end_value; counter ++) {");
        _builder.newLine();
        _builder.append("\t\t\t\t\t");
        _builder.append("i = i->ptrCacheLine[0];");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }
}

