/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.ros2.transformers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashSet;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.BooleanObject;
import org.eclipse.app4mc.amalthea.model.ChannelSend;
import org.eclipse.app4mc.amalthea.model.CommonElements;
import org.eclipse.app4mc.amalthea.model.InterProcessStimulus;
import org.eclipse.app4mc.amalthea.model.InterProcessTrigger;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Tag;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.Ticks;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.app4mc.amalthea.model.util.SoftwareUtil;
import org.eclipse.app4mc.slg.commons.m2t.transformers.AmaltheaModel2TextTransformer;
import org.eclipse.app4mc.slg.commons.m2t.transformers.sw.TicksUtilsTransformer;
import org.eclipse.app4mc.slg.ros2.generators.RosModel2TextGenerator;
import org.eclipse.app4mc.slg.ros2.transformers.RosBaseSettings;
import org.eclipse.app4mc.slg.ros2.transformers.common.RosAmlTransformer;
import org.eclipse.app4mc.slg.ros2.transformers.common.RosTagTransformer;
import org.eclipse.app4mc.slg.ros2.transformers.sw.RosLabelTransformer;
import org.eclipse.app4mc.transformation.util.OutputBuffer;

@Singleton
public class RosModel2TextTransformer
extends AmaltheaModel2TextTransformer {
    @Inject
    private OutputBuffer outputBuffer;
    @Inject
    private RosAmlTransformer amlTransformer;
    @Inject
    private RosTagTransformer tagTransformer;
    @Inject
    private TicksUtilsTransformer ticksUtilsTransformer;
    @Inject
    private RosLabelTransformer labelTransformer;
    private boolean label = false;
    private boolean ticks = false;
    private boolean interprocess = false;
    private boolean channelSend = false;
    private boolean performanceMeasurement = false;

    public void transform(Amalthea model, String outputFolder) {
        RosBaseSettings.initializeOutputBuffer(this.outputBuffer, outputFolder);
        this.amlTransformer.transform(model);
        CommonElements commonElements = ModelUtil.getOrCreateCommonElements((Amalthea)model);
        for (Tag tag : commonElements.getTags()) {
            this.tagTransformer.transform(tag, model);
        }
        HashSet<String> nodes = new HashSet<String>();
        HashSet<String> services = new HashSet<String>();
        SWModel swModel = ModelUtil.getOrCreateSwModel((Amalthea)model);
        for (Task task : swModel.getTasks()) {
            Stimulus stimulus = (Stimulus)task.getStimuli().get(0);
            for (Tag tag : task.getTags()) {
                nodes.add(tag.getName());
            }
            if (stimulus instanceof InterProcessStimulus) {
                services.add(String.valueOf(((InterProcessStimulus)stimulus).getName()) + "_service");
                continue;
            }
            for (Runnable run : SoftwareUtil.getRunnableList((Process)task, null)) {
                Value perf = (Value)run.getCustomProperties().get((Object)"measure_performance");
                if (perf instanceof BooleanObject && ((BooleanObject)perf).isValue()) {
                    this.performanceMeasurement = true;
                }
                for (ActivityGraphItem item : run.getRunnableItems()) {
                    if (item instanceof LabelAccess) {
                        this.label = true;
                    }
                    if (item instanceof Ticks) {
                        this.ticks = true;
                    }
                    if (item instanceof InterProcessTrigger) {
                        this.interprocess = true;
                    }
                    if (!(item instanceof ChannelSend)) continue;
                    this.channelSend = true;
                }
            }
        }
        this.ticksUtilsTransformer.createCMake();
        this.labelTransformer.createCMake();
        this.outputBuffer.appendTo("OTHER", "CMakeLists.txt", RosModel2TextGenerator.toCmake(nodes, services, this.label, this.ticks, this.interprocess, this.channelSend, this.performanceMeasurement));
        this.outputBuffer.appendTo("OTHER", "package.xml", RosModel2TextGenerator.toPackageXml(services));
        this.outputBuffer.appendTo("OTHER", "build.sh", RosModel2TextGenerator.toBuildScript(services));
        this.outputBuffer.appendTo("OTHER", "launch.py", RosModel2TextGenerator.toLaunchFile(nodes));
        this.outputBuffer.finish();
    }
}

