/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.ros2.transformers.sw;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.BooleanObject;
import org.eclipse.app4mc.amalthea.model.Channel;
import org.eclipse.app4mc.amalthea.model.ChannelSend;
import org.eclipse.app4mc.amalthea.model.InterProcessStimulus;
import org.eclipse.app4mc.amalthea.model.InterProcessTrigger;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.commons.m2t.transformers.sw.RunnableTransformer;
import org.eclipse.app4mc.slg.ros2.generators.RosRunnableGenerator;
import org.eclipse.app4mc.slg.ros2.transformers.sw.RosActivityGraphItemTransformer;
import org.eclipse.app4mc.slg.ros2.transformers.sw.RosRunnableCache;
import org.eclipse.app4mc.slg.ros2.transformers.utils.Utils;
import org.eclipse.app4mc.transformation.util.OutputBuffer;

public class RosRunnableTransformer
extends RunnableTransformer {
    public static final String LIB_NAME = "RUNNABLES_LIB";
    public static final String BASE_PATH = "synthetic_gen";
    public static final String MODULE_NAME = "runnables";
    public static final String MODULE_PATH = "synthetic_gen/runnables";
    public static final String MAKEFILE_PATH = "synthetic_gen/runnables/CMakeLists.txt";
    @Inject
    private OutputBuffer outputBuffer;
    @Inject
    private RosActivityGraphItemTransformer activityGraphItemTransformer;
    @Inject
    private RosRunnableCache rosRunnableCache;

    protected void genFiles(SLGTranslationUnit tu, Runnable runnable) {
        if (this.isSrcFileEmpty(tu)) {
            this.srcAppend(tu, "#include \"" + this.getIncFile(tu) + "\"\n");
        }
        LinkedHashSet<String> includes = new LinkedHashSet<String>();
        ArrayList<String> calls = new ArrayList<String>();
        boolean measurePerformance = false;
        if (runnable != null && runnable.getCustomProperties().get((Object)"measure_performance") instanceof BooleanObject) {
            measurePerformance = ((BooleanObject)runnable.getCustomProperties().get((Object)"measure_performance")).isValue();
        }
        if (measurePerformance) {
            includes.add("aml.h");
        }
        ArrayList<String> params = new ArrayList<String>();
        ArrayList<String> nodeParams = new ArrayList<String>();
        ArrayList<String> publishers = new ArrayList<String>();
        ArrayList<String> clientDeclarations = new ArrayList<String>();
        ArrayList<String> clientInits = new ArrayList<String>();
        if (runnable != null && runnable.getActivityGraph() != null) {
            for (ActivityGraphItem item : runnable.getActivityGraph().getItems()) {
                String call;
                SLGTranslationUnit graphItemTU = this.activityGraphItemTransformer.transform(item);
                String graphItemIncFile = this.getIncFile(graphItemTU);
                if (graphItemIncFile != null && !graphItemIncFile.isEmpty() && !this.getIncFile(tu).equals(graphItemIncFile)) {
                    includes.add(graphItemIncFile);
                }
                if (item instanceof ChannelSend) {
                    ChannelSend cs = (ChannelSend)item;
                    Channel data = cs.getData();
                    publishers.add(String.valueOf(data.getName()) + "_publisher");
                    nodeParams.add(String.valueOf(data.getName()) + "_publisher");
                    params.add("rclcpp::Publisher<std_msgs::msg::String>::SharedPtr& " + data.getName() + "_publisher");
                }
                if (item instanceof InterProcessTrigger) {
                    InterProcessTrigger trigger = (InterProcessTrigger)item;
                    InterProcessStimulus stimulus = trigger.getStimulus();
                    String stimName = stimulus.getName();
                    String idlName = Utils.toIdlCompliantName(String.valueOf(stimName) + "_service");
                    includes.add(String.valueOf(stimName) + "_service/srv/" + stimName + "_service" + ".hpp");
                    clientDeclarations.add("rclcpp::Client<" + stimName + "_service::srv::" + idlName + ">::SharedPtr " + stimName + "_client");
                    clientInits.add(String.valueOf(stimName) + "_client =  this->create_client<" + stimName + "_service::srv::" + idlName + ">" + "(\"" + stimName + "_service\")");
                    nodeParams.add(String.valueOf(stimName) + "_client");
                    params.add("rclcpp::Client<" + stimName + "_service::srv::" + idlName + ">::SharedPtr& " + stimName + "_client");
                }
                if ((call = graphItemTU.getCall()) == null || call.isEmpty()) continue;
                calls.add(call);
            }
        }
        String nodeParam = String.join((CharSequence)";", nodeParams);
        String param = String.join((CharSequence)";", params);
        this.rosRunnableCache.storeValues(tu, runnable, param, nodeParam, publishers, clientDeclarations, clientInits);
        String fullCall = "run_" + runnable.getName() + "(" + param + ")";
        this.incAppend(tu, "\n//Runnable " + runnable.getName() + "----\n");
        this.toH(tu, includes, fullCall);
        this.srcAppend(tu, "\n//Runnable " + runnable.getName() + "----\n");
        this.toCpp(tu, runnable.getName(), fullCall, calls, measurePerformance);
    }

    protected void toH(SLGTranslationUnit tu, HashSet<String> includes, String fullCall) {
        for (String include : includes) {
            this.incAppend(tu, "#include \"" + include + "\"\n");
        }
        this.incAppend(tu, "void " + fullCall + ";\n");
    }

    protected void toCpp(SLGTranslationUnit tu, String runnableName, String fullCall, List<String> calls, boolean measurePerformance) {
        this.srcAppend(tu, "void " + fullCall + "{\n");
        if (measurePerformance) {
            this.srcAppend(tu, "uint64_t event_list[] = {0x11, 0x13, 0x17}; //CPU CYCLES, MEM ACCESS, L2 Cache Refill\nint total_events =  sizeof(event_list)/sizeof(event_list[0]);\nint fd = instrument_start(0,event_list, total_events);\n");
        }
        for (String call : calls) {
            this.srcAppend(tu, "\t" + call + ";\n");
        }
        if (measurePerformance) {
            this.srcAppend(tu, "instrument_stop(fd, \"" + runnableName + ".log\");\n");
        }
        this.srcAppend(tu, "}\n\n");
    }

    public boolean createCMake() {
        return this.outputBuffer.appendTo("OTHER", MAKEFILE_PATH, RosRunnableGenerator.toCMake(LIB_NAME, this.getSrcFiles()));
    }
}

