/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.ros2.transformers.sw;

import com.google.inject.Singleton;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.ros2.generators.RosTaskGenerator;

@Singleton
public class RosTaskCache {
    private Map<SLGTranslationUnit, TaskStore> cache = new HashMap<SLGTranslationUnit, TaskStore>();

    public TaskStore getStore(SLGTranslationUnit tu) {
        return this.cache.get(tu);
    }

    public void storeValues(SLGTranslationUnit tu, Task task, Collection<Stimulus> stimuli, Collection<String> includes, Collection<String> initCalls, Collection<String> stepCalls, Collection<String> publishers, Collection<String> clientDeclarations, Collection<String> clientInits) {
        TaskStore store = new TaskStore(task, stimuli, includes, initCalls, stepCalls, publishers, clientDeclarations, clientInits);
        this.cache.put(tu, store);
    }

    public class TaskStore {
        private final Task task;
        private final Collection<Stimulus> stimuli;
        private final Collection<String> includes;
        private final Collection<String> initCalls;
        private final Collection<String> stepCalls;
        private final Collection<String> publishers;
        private final Collection<String> clientDeclarations;
        private final Collection<String> clientInits;

        public TaskStore(Task task, Collection<Stimulus> stimuli, Collection<String> includes, Collection<String> initCalls, Collection<String> stepCalls, Collection<String> publishers, Collection<String> clientDeclarations, Collection<String> clientInits) {
            this.task = task;
            this.stimuli = stimuli;
            this.includes = includes;
            this.initCalls = initCalls;
            this.stepCalls = stepCalls;
            this.publishers = publishers;
            this.clientDeclarations = clientDeclarations;
            this.clientInits = clientInits;
        }

        public Task getTask() {
            return this.task;
        }

        public Collection<Stimulus> getStimuli() {
            return this.stimuli;
        }

        public Collection<String> getIncludes() {
            return this.includes;
        }

        public Collection<String> getInitCalls() {
            return this.initCalls;
        }

        public Collection<String> getStepCalls() {
            return this.stepCalls;
        }

        public Collection<String> getPublishers() {
            return this.publishers;
        }

        public Collection<String> getClientDeclarations() {
            return this.clientDeclarations;
        }

        public Collection<String> getClientInits() {
            return this.clientInits;
        }

        public String getDeclaration() {
            return RosTaskGenerator.getDeclaration(this.stimuli, this.publishers, this.clientDeclarations);
        }

        public String getInitialisation(String nodeName) {
            return RosTaskGenerator.getInitialisation(nodeName, this.stimuli, this.publishers, this.clientInits);
        }

        public String getServiceCallback() {
            return RosTaskGenerator.getServiceCallback(this.stimuli, this.stepCalls);
        }

        public String getCallback() {
            return RosTaskGenerator.getCallback(this.stimuli, this.stepCalls);
        }

        public String getHeaders() {
            return RosTaskGenerator.getHeaders(this.includes);
        }
    }
}

