/**
 * Copyright (c) 2020-2021 Robert Bosch GmbH.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 */

package org.eclipse.app4mc.slg.ros2.generators

import java.util.List
import org.eclipse.app4mc.amalthea.model.Label

class RosLabelGenerator {

	// Suppress default constructor
	private new() {
		throw new IllegalStateException("Utility class");
	}

	// ---------- names of generated 'C' functions ----------

	static def String initCall(String labelName) { initCall(labelName, "_CacheLine* array,int array_elements") }

	static def String initCall(String labelName, String param) 	'''initialize_«labelName»(«labelName»«param»)'''	
	static def String readCall(String labelName, String param) 	'''read_«labelName»(«param»)'''	
	static def String writeCall(String labelName, String param)	'''write_«labelName»(«param»)'''	

	// ---------- generate file contents ----------

	static def String toCMake(String libName, List<String> srcFiles)
	'''
		# «libName» ################################################################
		####
		add_library(«libName»  STATIC
		«FOR srcFile : srcFiles»
			«""»	${CMAKE_CURRENT_LIST_DIR}/_src/«srcFile»
		«ENDFOR»
		)
		
		target_include_directories(«libName»
			    PUBLIC ${CMAKE_CURRENT_LIST_DIR}/_inc
		)	
	'''


	static def String toH(Label label) {
		val name = if (label?.name.isNullOrEmpty) "<undefined label>" else label.name

		'''
		typedef struct «name»_CacheLine
		{
		  struct «name»_CacheLine* ptrCacheLine[8] ;
		} «name»_CacheLine ;
		void «initCall(name, "_CacheLine* array, int array_elements")»;
		void «readCall(name, "int labelAccessStatistics")»;
		void «writeCall(name, "int labelAccessStatistics")»;
		
		'''
	}

	static def String toCpp(Label label) {
		val name = if (label?.name.isNullOrEmpty) "<undefined label>" else label.name
		val numberOfBytes = if (label?.size === null) 0 else label.size.numberBytes

		'''
		void initialize_«name»(«name»_CacheLine* array,int array_elements) {
		  int steps = array_elements / 2 ;
		  int bottom = 0 ;
		  int top = steps ;
		  int i = 0;
		  for (i = 0 ; i < steps ; i++) {
		    array[bottom].ptrCacheLine[0] = &array[top] ;
		    array[top].ptrCacheLine[0] = &array[bottom+1] ;
		    top++ ;
		    bottom++ ;
		  }
		  array[(array_elements-1)].ptrCacheLine[0] = NULL ;	
		}
		
		
		
		void «readCall(label.name, "int labelAccessStatistics")» {
			static bool initialized = false;
				int numberOfBytes = «numberOfBytes»;
				static «name»_CacheLine* «name»;
				if(!initialized) {
					//init
					«name» = («name»_CacheLine*) malloc(sizeof(«name»_CacheLine) * 17000);
					initialize_«name»(«name», 17000);
					initialized = true;
				}
			
				static «name»_CacheLine* i = «name»;
				static int counter = 0;
			
				if(counter > 16100) {
					counter = 0;
					i = «name»;
				}
			
				int end_value = counter + numberOfBytes;
			
				for(; counter < end_value; counter ++) {
					i = i->ptrCacheLine[0];
				}
		
		}
		
		
		
		void «writeCall(label.name, "int labelAccessStatistics")» {
			static bool initialized = false;
						int numberOfBytes = «numberOfBytes»;
						static «name»_CacheLine* «name»;
						if(!initialized) {
							//init
							«name» = («name»_CacheLine*) malloc(sizeof(«name»_CacheLine) * 17000);
							initialize_«name»(«name», 17000);
							initialized = true;
						}
					
						static «name»_CacheLine* i = «name»;
						static int counter = 0;
					
						if(counter > 16100) {
							counter = 0;
							i = «name»;
						}
					
						int end_value = counter + numberOfBytes;
					
						for(; counter < end_value; counter ++) {
							i = i->ptrCacheLine[0];
						}
		}
		
		'''
	}

}
