/**
 ********************************************************************************
 * Copyright (c) 2020-2021 Robert Bosch GmbH.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 * *******************************************************************************
 */

package org.eclipse.app4mc.slg.ros2.transformers.sw;

import org.eclipse.app4mc.amalthea.model.ActivityGraphItem;
import org.eclipse.app4mc.amalthea.model.ChannelSend;
import org.eclipse.app4mc.amalthea.model.InterProcessTrigger;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.commons.m2t.transformers.sw.ActivityGraphItemTransformer;

import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class RosActivityGraphItemTransformer extends ActivityGraphItemTransformer {

	@Inject private RosInterProcessTriggerTransformer ipTransformer;
	@Inject private RosChannelSendTransformer channelSendTransformer;

	@Override
	public SLGTranslationUnit transform(final ActivityGraphItem graphItem) {
		if (graphItem == null) {
			throw new IllegalArgumentException("Unhandled parameter type: null");
		}

		if (graphItem instanceof InterProcessTrigger) {
			return ipTransformer.transform((InterProcessTrigger) graphItem);

		} else if (graphItem instanceof ChannelSend) {
			return channelSendTransformer.transform((ChannelSend) graphItem);

		} else {
			return super.transform(graphItem);
		}
	}

}
