/**
 ********************************************************************************
 * Copyright (c) 2020-2021 Robert Bosch GmbH.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 * *******************************************************************************
 */

package org.eclipse.app4mc.slg.ros2.transformers.sw;

import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.commons.m2t.transformers.sw.LabelTransformer;
import org.eclipse.app4mc.slg.ros2.generators.RosLabelGenerator;
import org.eclipse.app4mc.transformation.util.OutputBuffer;

import com.google.inject.Inject;

public class RosLabelTransformer extends LabelTransformer {

	public static final String LIB_NAME = "LABELS_LIB";
	public static final String BASE_PATH = "synthetic_gen";
	public static final String MODULE_NAME = "labels";
	public static final String MODULE_PATH = BASE_PATH + "/" + MODULE_NAME;
	public static final String MAKEFILE_PATH = MODULE_PATH + "/CMakeLists.txt";

	@Inject private OutputBuffer outputBuffer;

	@Override
	protected void genFiles(SLGTranslationUnit tu, Label label) {
		if (isSrcFileEmpty(tu)) {
			srcAppend(tu,"#include \"" + getIncFile(tu) + "\"\n\n");
			srcAppend(tu, "#include <stdlib.h>\n");
		}		
		incAppend(tu, RosLabelGenerator.toH(label));
		srcAppend(tu, RosLabelGenerator.toCpp(label));
	}

	@Override
	public boolean createCMake() {
		return outputBuffer.appendTo(
				"OTHER", MAKEFILE_PATH, RosLabelGenerator.toCMake(LIB_NAME, getSrcFiles()));
	}

}
