/**
 ********************************************************************************
 * Copyright (c) 2020-2021 Robert Bosch GmbH.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 * *******************************************************************************
 */

package org.eclipse.app4mc.slg.ros2.transformers.sw;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;

import com.google.inject.Singleton;

@Singleton
public class RosRunnableCache {

	private Map<SLGTranslationUnit, RunnableStore> cache = new HashMap<>();

	public RunnableStore getStore(SLGTranslationUnit tu) {
		return cache.get(tu);
	}

	public void storeValues(SLGTranslationUnit tu, Runnable runnable, String param, String nodeParam,
			Collection<String> publishers, Collection<String> clientDeclarations, Collection<String> clientInits) {
		RunnableStore store = new RunnableStore(runnable, param, nodeParam, publishers, clientDeclarations, clientInits);
		cache.put(tu, store);
	}

	public class RunnableStore {
		private final Runnable runnable;
		private final String param;
		private final String nodeParam;
		private final Collection<String> publishers;
		private final Collection<String> clientDeclarations;
		private final Collection<String> clientInits;

		public RunnableStore(Runnable runnable, String param, String nodeParam, Collection<String> publishers,
				Collection<String> clientDeclarations, Collection<String> clientInits) {
			this.runnable = runnable;
			this.param = param;
			this.nodeParam = nodeParam;
			this.publishers = publishers;
			this.clientDeclarations = clientDeclarations;
			this.clientInits = clientInits;
		}

		public Runnable getRunnable() {
			return runnable;
		}

		public String getParam() {
			return param;
		}

		public String getNodeParam() {
			return nodeParam;
		}

		public Collection<String> getPublishers() {
			return publishers;
		}

		public Collection<String> getClientDeclarations() {
			return clientDeclarations;
		}

		public Collection<String> getClientInits() {
			return clientInits;
		}

		public String getCall() {
			return "run_" + runnable.getName() + "(" + param + ")";
		}

		public String getNodeCall() {
			return "run_" + runnable.getName() + "(" + nodeParam + ")";
		}
	}

}
