/**
 * *******************************************************************************
 * Copyright (c) 2021 Robert Bosch GmbH.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 * *******************************************************************************
 */

package org.eclipse.app4mc.slg.config.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.app4mc.slg.config.CodeHooks;
import org.eclipse.app4mc.slg.config.CodehookType;
import org.eclipse.app4mc.slg.config.ConfigModel;
import org.eclipse.app4mc.slg.config.HeaderFiles;

public class ConfigModelUtils {

	// Suppress default constructor
	private ConfigModelUtils() {
		throw new IllegalStateException("Utility class");
	}

	public static List<String> getHeaderFilesDirectories(ConfigModel configModel, CodehookType codehookType) {

		List<String> ls = new ArrayList<>();

		CodeHooks codeHooks = configModel.getCodeHooks();
		if (codeHooks != null) {
			for (HeaderFiles headerFile : codeHooks.getHeaderFiles()) {
				if (headerFile.getCodehookType().getName().equals(codehookType.getName())) {
					for (String hfileDir : headerFile.getHeaderFilesDirectories()) {
						ls.add(hfileDir);
					}

				}
				return ls;
			}

		}

		return ls;
	}

	public static String getHeaderFilesIncludeMultiString(File folder) {
		if (folder == null) return null;

		StringBuilder sb = new StringBuilder();

		if (folder.exists() && folder.isDirectory()) {

			for (File fileEntry : folder.listFiles()) {
				if (!fileEntry.isDirectory() && fileEntry.getName().endsWith(".h")) {
					sb.append("#include \"");
					sb.append(fileEntry.getName());
					sb.append('\"');
					sb.append(System.getProperty("line.separator"));
				}
			}

		} else {
			System.err.println("Input header folder doesnot exist/it is not a directory : " + folder.getPath());
		}

		return sb.toString();
	}
}
