/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.config.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.app4mc.slg.config.CodeHooks;
import org.eclipse.app4mc.slg.config.CodehookType;
import org.eclipse.app4mc.slg.config.ConfigModel;
import org.eclipse.app4mc.slg.config.HeaderFiles;

public class ConfigModelUtils {
    private ConfigModelUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static List<String> getHeaderFilesDirectories(ConfigModel configModel, CodehookType codehookType) {
        Iterator iterator;
        ArrayList<String> ls = new ArrayList<String>();
        CodeHooks codeHooks = configModel.getCodeHooks();
        if (codeHooks != null && (iterator = codeHooks.getHeaderFiles().iterator()).hasNext()) {
            HeaderFiles headerFile = (HeaderFiles)iterator.next();
            if (headerFile.getCodehookType().getName().equals(codehookType.getName())) {
                for (String hfileDir : headerFile.getHeaderFilesDirectories()) {
                    ls.add(hfileDir);
                }
            }
            return ls;
        }
        return ls;
    }

    public static String getHeaderFilesIncludeMultiString(File folder) {
        if (folder == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (folder.exists() && folder.isDirectory()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File fileEntry = fileArray[n2];
                if (!fileEntry.isDirectory() && fileEntry.getName().endsWith(".h")) {
                    sb.append("#include \"");
                    sb.append(fileEntry.getName());
                    sb.append('\"');
                    sb.append(System.getProperty("line.separator"));
                }
                ++n2;
            }
        } else {
            System.err.println("Input header folder doesnot exist/it is not a directory : " + folder.getPath());
        }
        return sb.toString();
    }
}

