/**
 * Copyright (c) 2020-2021 Robert Bosch GmbH.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 */
package org.eclipse.app4mc.slg.ros2.generators;

import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class RosAmlGenerator {
  private RosAmlGenerator() {
    throw new IllegalStateException("Utility class");
  }
  
  public static String toCpp() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#include \"aml.h\"");
    _builder.newLine();
    _builder.append("#include <mutex>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("std::mutex lock_;");
    _builder.newLine();
    _builder.append("static long perf_event_define(pid_t proccess_id, int group_fd, uint64_t pinned, uint32_t event_type, uint64_t event)");
    _builder.newLine();
    _builder.append("{\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("struct perf_event_attr hw_event;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("pid_t pid = proccess_id; \t    // measure the current process/thread");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("int cpu = -1; \t                // measure on any cpu");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("unsigned long flags = 0;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("int fd_current;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("memset(&hw_event, 0, sizeof(struct perf_event_attr));");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("hw_event.type = event_type;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("hw_event.size = sizeof(struct perf_event_attr);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("hw_event.config = event;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("hw_event.disabled = 1;          // off by default. specifies whether the counter starts out disabled or enabled.");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("hw_event.exclude_kernel = 1; \t// excluding events that happen in the kernel-space");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("hw_event.exclude_hv = 1;      \t// excluding events that happen in the hypervisor");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("hw_event.pinned = pinned;\t\t// specifies the counter to be on the CPU if at all possible. applies only to hardware counters and only to group leaders.");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("hw_event.exclude_user = 0; \t\t//  excludes events that happen in user space");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("hw_event.exclude_callchain_kernel  = 1; // Do not include kernel callchains.");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("hw_event.exclude_callchain_user = 0;\t// Do not include user callchains.");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// hw_event.inherit = 1;\t\t// Inherit does not work for some combinations of read_format values, such as PERF_FORMAT_GROUP.");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//hw_event.exclusive = 1;\t\t// not working for counters other than cycle counter");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//hw_event.exclude_idle = 1; \t// doesn\'t work");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("hw_event.read_format = PERF_FORMAT_GROUP; // Allows all counter values in an event group to be read with one read");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("fd_current = syscall(__NR_perf_event_open, &hw_event, pid, cpu, group_fd, flags);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (fd_current == -1) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("int error_num = errno;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t  ");
    _builder.append("printf(\"Error opening leader %llx\\n\", hw_event.config);");
    _builder.newLine();
    _builder.append("\t  ");
    _builder.append("printf(\"Errno error code %d\\n\", error_num);");
    _builder.newLine();
    _builder.append("\t  ");
    _builder.append("exit(EXIT_FAILURE);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t  ");
    _builder.append("return fd_current;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("int instrument_start(pid_t pid, uint64_t event_list[], int total_events){");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("lock_.lock();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("static int called = 0;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("static int fd;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if(!called) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("int i;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("fd = perf_event_define(pid, -1, 1, PERF_TYPE_HARDWARE, PERF_COUNT_HW_CPU_CYCLES);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("//perf_event_define(pid, fd, 0, PERF_TYPE_RAW, )");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for (i = 0; i < total_events; i++)");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("perf_event_define(pid, fd, 0, PERF_TYPE_RAW, event_list[i]);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("/* Example usage:");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("perf_event_define(fd, 0, PERF_TYPE_RAW, 0x0008);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("perf_event_define(fd, 0, PERF_TYPE_RAW, 0x0012);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("perf_event_define(fd, 0, PERF_TYPE_RAW, 0x0004);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("perf_event_define(fd, 0, PERF_TYPE_RAW, 0x0003);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("perf_event_define(fd, 0, PERF_TYPE_RAW, 0x0016);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("perf_event_define(fd, 0, PERF_TYPE_RAW, 0x0017);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("int fd = perf_event_define(-1, 1, PERF_TYPE_HARDWARE, PERF_COUNT_HW_CPU_CYCLES);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("perf_event_define(fd, 0, PERF_TYPE_HARDWARE, PERF_COUNT_HW_INSTRUCTIONS);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("perf_event_define(fd, 0, PERF_TYPE_HARDWARE, PERF_COUNT_HW_BRANCH_INSTRUCTIONS);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("perf_event_define(fd , 0, PERF_TYPE_HARDWARE, PERF_COUNT_HW_CACHE_REFERENCES);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("perf_event_define(fd , 0, PERF_TYPE_HARDWARE, PERF_COUNT_HW_CACHE_MISSES);");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("perf_event_define(fd , 0, PERF_TYPE_HW_CACHE, (PERF_COUNT_HW_CACHE_LL) | (PERF_COUNT_HW_CACHE_OP_READ << 8) | (PERF_COUNT_HW_CACHE_RESULT_ACCESS << 16));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("perf_event_define(fd , 0, PERF_TYPE_HW_CACHE, (PERF_COUNT_HW_CACHE_LL) | (PERF_COUNT_HW_CACHE_OP_READ << 8) | (PERF_COUNT_HW_CACHE_RESULT_MISS << 16));");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("called = 1;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ioctl(fd, PERF_EVENT_IOC_RESET, PERF_IOC_FLAG_GROUP);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ioctl(fd, PERF_EVENT_IOC_ENABLE, PERF_IOC_FLAG_GROUP);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return fd;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("struct read_format {");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("uint64_t nr; \t\t// The number of events");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("struct {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("uint64_t value; // The value of the event");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("} values[];");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void instrument_stop(int fd, char* filename){");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ioctl(fd, PERF_EVENT_IOC_DISABLE, PERF_IOC_FLAG_GROUP);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("char buf[4096];");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("read(fd, buf, sizeof(buf));");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("int i = 0;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("struct read_format* rf = (struct read_format*) buf;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("FILE * file_pointer;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("file_pointer = fopen(filename, \"a\");");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for (i = 0; i < rf->nr; i++)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("fprintf(file_pointer, \"%\" PRId64 \"\\t\", rf->values[i].value);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("fprintf(file_pointer, \"\\n\");");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("fclose(file_pointer);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("//close(fd);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("lock_.unlock();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void instrument_read(int fd){");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("char buf[4096];");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("read(fd, buf, sizeof(buf));");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("int i;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("struct read_format* rf = (struct read_format*) buf;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("FILE * file_pointer;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("file_pointer = fopen(\"output.log\", \"a\");");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for (i = 0; i < rf->nr; i++)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("fprintf(file_pointer, \"%\" PRId64 \"\\t\", rf->values[i].value);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("fprintf(file_pointer, \"\\n\");");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("fclose(file_pointer);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ioctl(fd, PERF_EVENT_IOC_RESET, PERF_IOC_FLAG_GROUP);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.newLine();
    _builder.append("void instrument_read_to_file(int fd, char* filename){");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ioctl(fd, PERF_EVENT_IOC_DISABLE, PERF_IOC_FLAG_GROUP);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("char buf[4096];");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("read(fd, buf, sizeof(buf));");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("int i;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("struct read_format* rf = (struct read_format*) buf;");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("FILE * file_pointer;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("file_pointer = fopen(filename, \"a\");");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("for (i = 0; i < rf->nr; i++)");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("fprintf(file_pointer, \"%\" PRId64 \"\\t\", rf->values[i].value);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("fprintf(file_pointer, \"\\n\");");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("fclose(file_pointer);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ioctl(fd, PERF_EVENT_IOC_RESET, PERF_IOC_FLAG_GROUP);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ioctl(fd, PERF_EVENT_IOC_ENABLE, PERF_IOC_FLAG_GROUP);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("void instrument_reset(int fd) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("ioctl(fd, PERF_EVENT_IOC_RESET, PERF_IOC_FLAG_GROUP);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    return _builder.toString();
  }
  
  public static String toH() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#include <stdlib.h>");
    _builder.newLine();
    _builder.append("#include <stdio.h>");
    _builder.newLine();
    _builder.append("#include <unistd.h>");
    _builder.newLine();
    _builder.append("#include <string.h>");
    _builder.newLine();
    _builder.append("#include <sys/types.h>");
    _builder.newLine();
    _builder.append("#include <sys/ioctl.h>");
    _builder.newLine();
    _builder.append("#include <linux/perf_event.h>");
    _builder.newLine();
    _builder.append("#include <linux/hw_breakpoint.h>");
    _builder.newLine();
    _builder.append("#include <asm/unistd.h>");
    _builder.newLine();
    _builder.append("#include <inttypes.h>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include <errno.h>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("int instrument_start(pid_t pid, uint64_t event_list[], int total_events);");
    _builder.newLine();
    _builder.append("void instrument_stop(int fd, char* filename);");
    _builder.newLine();
    _builder.append("void instrument_read(int fd);");
    _builder.newLine();
    _builder.append("void instrument_reset(int fd);");
    _builder.newLine();
    _builder.append("void instrument_read_to_file(int fd, char* filename);");
    _builder.newLine();
    return _builder.toString();
  }
}
