/**
 * Copyright (c) 2020-2021 Robert Bosch GmbH.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 */
package org.eclipse.app4mc.slg.ros2.generators;

import java.util.HashSet;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.StringObject;
import org.eclipse.app4mc.amalthea.model.Tag;
import org.eclipse.app4mc.amalthea.model.Value;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class RosTagGenerator {
  private RosTagGenerator() {
    throw new IllegalStateException("Utility class");
  }
  
  public static String toCpp(final Tag tag, final String moduleName, final HashSet<String> headers, final List<String> declarations, final List<String> inits, final List<String> calls, final List<String> serviceCallbacks) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("#include <chrono>");
    _builder.newLine();
    _builder.append("#include <memory>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("#include \"rclcpp/rclcpp.hpp\"");
    _builder.newLine();
    _builder.append("#include \"std_msgs/msg/string.hpp\"");
    _builder.newLine();
    _builder.append("\t\t\t\t\t\t\t  ");
    _builder.newLine();
    {
      for(final String header : headers) {
        _builder.append(header);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("using namespace std::chrono_literals;");
    _builder.newLine();
    _builder.append("using std::placeholders::_1;");
    _builder.newLine();
    _builder.newLine();
    {
      for(final String serviceCallback : serviceCallbacks) {
        _builder.append(serviceCallback);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("class ");
    _builder.append(moduleName);
    _builder.append(" : public rclcpp::Node");
    _builder.newLineIfNotEmpty();
    _builder.append("{");
    _builder.newLine();
    _builder.append("private:");
    _builder.newLine();
    {
      for(final String declaration : declarations) {
        _builder.append("  ");
        _builder.append(declaration, "  ");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public:");
    _builder.newLine();
    _builder.append("\t  ");
    _builder.append(moduleName, "\t  ");
    _builder.append("()");
    _builder.newLineIfNotEmpty();
    _builder.append("\t  ");
    _builder.append(": Node(\"");
    String _lowerCase = moduleName.toLowerCase();
    _builder.append(_lowerCase, "\t  ");
    _builder.append("\")");
    _builder.newLineIfNotEmpty();
    _builder.append("\t  ");
    _builder.append("{");
    _builder.newLine();
    {
      for(final String init : inits) {
        _builder.append("\t  \t");
        _builder.append(init, "\t  \t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t  \t");
    _builder.newLine();
    _builder.append("\t  \t");
    _builder.append("}");
    _builder.newLine();
    {
      for(final String call : calls) {
        _builder.append("\t  \t");
        _builder.append(call, "\t  \t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t  \t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("};");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("int main(int argc, char * argv[])");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("{\t\t  ");
    _builder.newLine();
    _builder.append("\t\t  ");
    _builder.append("setvbuf(stdout, NULL, _IONBF, BUFSIZ);");
    _builder.newLine();
    _builder.append("\t\t   ");
    _builder.append("rclcpp::init(argc, argv);");
    _builder.newLine();
    {
      Value _get = tag.getCustomProperties().get("executor_type");
      boolean _tripleNotEquals = (_get != null);
      if (_tripleNotEquals) {
        {
          Value _get_1 = tag.getCustomProperties().get("executor_type");
          boolean _equals = ((StringObject) _get_1).getValue().equals("single_thread");
          if (_equals) {
            _builder.append("\t\t   ");
            _builder.append("rclcpp::executors::SingleThreadedExecutor executor;");
            _builder.newLine();
          } else {
            _builder.append("\t\t   ");
            _builder.append("rclcpp::executors::MultiThreadedExecutor executor;");
            _builder.newLine();
          }
        }
      } else {
        _builder.append("\t\t   ");
        _builder.append("rclcpp::executors::MultiThreadedExecutor executor;");
        _builder.newLine();
      }
    }
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t  ");
    _builder.append("auto node = std::make_shared<");
    _builder.append(moduleName, "\t\t  ");
    _builder.append(">();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t  ");
    _builder.append("executor.add_node(node);");
    _builder.newLine();
    _builder.append("\t\t  ");
    _builder.append("executor.spin();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t  ");
    _builder.append("rclcpp::shutdown();");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.newLine();
    _builder.append("\t\t  ");
    _builder.append("return 0;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    return _builder.toString();
  }
}
