/**
 ********************************************************************************
 * Copyright (c) 2020-2021 Robert Bosch GmbH.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
 * *******************************************************************************
 */

package org.eclipse.app4mc.slg.ros2.transformers.common;


import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.ros2.generators.RosAmlGenerator;
import org.eclipse.app4mc.slg.ros2.transformers.RosBaseTransformer;

public class RosAmlTransformer extends RosBaseTransformer {

	public SLGTranslationUnit transform(final Amalthea model) {
		final SLGTranslationUnit tu = createTranslationUnit(model);

		// if translation unit is newly created and valid -> create files
		if (tu.isValid()) {
			doTransform(tu);
		}

		return tu;
	}

	private SLGTranslationUnit createTranslationUnit(final Amalthea model) {
		if (model == null) {
			return new SLGTranslationUnit("UNSPECIFIED MODEL");
		} else {
			String basePath = "utils";
			String moduleName = "aml";
			String call = ""; // unused
			return new SLGTranslationUnit(basePath, moduleName, call);
		}
	}

	private void doTransform(final SLGTranslationUnit tu) {
		genFiles(tu);
	}

	private void genFiles(SLGTranslationUnit tu) {
		incAppend(tu, RosAmlGenerator.toH());
		srcAppend(tu, RosAmlGenerator.toCpp());
	}

}
