/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.ros2.transformers;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.transformation.util.OutputBuffer;

public abstract class RosBaseTransformer {
    @Inject
    private OutputBuffer outputBuffer;

    public boolean isIncFileEmpty(SLGTranslationUnit tu) {
        return !this.outputBuffer.bufferExists("INC", this.getIncModulePath(tu));
    }

    public boolean isSrcFileEmpty(SLGTranslationUnit tu) {
        return !this.outputBuffer.bufferExists("SRC", this.getSrcModulePath(tu));
    }

    public boolean incAppend(SLGTranslationUnit tu, String str) {
        return this.outputBuffer.appendTo("INC", this.getIncModulePath(tu), str);
    }

    public boolean srcAppend(SLGTranslationUnit tu, String str) {
        return this.outputBuffer.appendTo("SRC", this.getSrcModulePath(tu), str);
    }

    public String getIncModulePath(SLGTranslationUnit tu) {
        return String.valueOf(tu.getModulePath()) + "/_inc/" + tu.getModuleName();
    }

    public String getSrcModulePath(SLGTranslationUnit tu) {
        return String.valueOf(tu.getModulePath()) + "/_src/" + tu.getModuleName();
    }

    public String getIncPath(SLGTranslationUnit tu) {
        return String.valueOf(tu.getModulePath()) + "/_inc/" + this.getIncFile(tu);
    }

    public String getSrcPath(SLGTranslationUnit tu) {
        return String.valueOf(tu.getModulePath()) + "/_src/" + this.getSrcFile(tu);
    }

    public String getIncFile(SLGTranslationUnit tu) {
        return String.valueOf(tu.getModuleName()) + this.outputBuffer.getFileExtension("INC");
    }

    public String getSrcFile(SLGTranslationUnit tu) {
        return String.valueOf(tu.getModuleName()) + this.outputBuffer.getFileExtension("SRC");
    }

    public List<String> getSrcFiles() {
        return this.getCache().values().stream().map(this::getSrcFile).sorted().distinct().collect(Collectors.toList());
    }

    public Map<List<Object>, SLGTranslationUnit> getCache() {
        return Collections.emptyMap();
    }
}

