/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.slg.ros2.transformers.common;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.IAnnotatable;
import org.eclipse.app4mc.amalthea.model.Tag;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.slg.commons.m2t.transformers.SLGTranslationUnit;
import org.eclipse.app4mc.slg.ros2.generators.RosTagGenerator;
import org.eclipse.app4mc.slg.ros2.transformers.RosBaseTransformer;
import org.eclipse.app4mc.slg.ros2.transformers.sw.RosTaskCache;
import org.eclipse.app4mc.slg.ros2.transformers.sw.RosTaskTransformer;

@Singleton
public class RosTagTransformer
extends RosBaseTransformer {
    @Inject
    private RosTaskTransformer rosTaskTransformer;
    @Inject
    private RosTaskCache rosTaskCache;
    private final Map<List<Object>, SLGTranslationUnit> transformCache = new HashMap<List<Object>, SLGTranslationUnit>();

    @Override
    public Map<List<Object>, SLGTranslationUnit> getCache() {
        return this.transformCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SLGTranslationUnit transform(Tag tag, Amalthea model) {
        SLGTranslationUnit tu;
        ArrayList<IAnnotatable> key = new ArrayList<IAnnotatable>(Arrays.asList(tag, model));
        Map<List<Object>, SLGTranslationUnit> map = this.transformCache;
        synchronized (map) {
            if (this.transformCache.containsKey(key)) {
                return this.transformCache.get(key);
            }
            tu = this.createTranslationUnit(tag);
            this.transformCache.put(key, tu);
        }
        if (tu.isValid()) {
            this.doTransform(tu, tag, model);
        }
        return tu;
    }

    private SLGTranslationUnit createTranslationUnit(Tag tag) {
        if (tag == null) {
            return new SLGTranslationUnit("UNSPECIFIED TAG");
        }
        String basePath = "";
        String moduleName = tag.getName();
        String call = "";
        return new SLGTranslationUnit(basePath, moduleName, call);
    }

    private void doTransform(SLGTranslationUnit tu, Tag tag, Amalthea model) {
        this.genFiles(tu, tag, model);
    }

    private void genFiles(SLGTranslationUnit tu, Tag tag, Amalthea model) {
        HashSet<String> header = new HashSet<String>();
        LinkedList<String> declaration = new LinkedList<String>();
        LinkedList<String> initialization = new LinkedList<String>();
        LinkedList<String> calls = new LinkedList<String>();
        LinkedList<String> serviceCallbacks = new LinkedList<String>();
        if (model != null && model.getSwModel() != null) {
            for (Task task : model.getSwModel().getTasks()) {
                if (!task.getTags().contains((Object)tag)) continue;
                SLGTranslationUnit taskTU = this.rosTaskTransformer.transform(task);
                RosTaskCache.TaskStore store = this.rosTaskCache.getStore(taskTU);
                header.add(store.getHeaders());
                declaration.add(store.getDeclaration());
                initialization.add(store.getInitialisation(tu.getModuleName()));
                calls.add(store.getCallback());
                serviceCallbacks.add(store.getServiceCallback());
            }
        }
        this.srcAppend(tu, RosTagGenerator.toCpp(tag, tu.getModuleName(), header, declaration, initialization, calls, serviceCallbacks));
    }
}

